
/*
 * Copyright (C) 2010-2015 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IFile.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_5_0;

import org.virtualbox_5_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Abstract parent interface for files handled by VirtualBox.

Interface ID: <tt>{14C66B23-404C-F24A-3CC1-EE9501D44F2A}</tt>
*/
public class IFile extends IUnknown
{

    public IFile(String wrapped, VboxPortType port)
    {
        super(wrapped, port);
    }

/**
Event source for file events.
@return org.virtualbox_5_0.IEventSource
*/
    public org.virtualbox_5_0.IEventSource getEventSource()
    {
        try
        {
            String retVal = port.iFileGetEventSource(obj);
            return (retVal.length() > 0) ? new org.virtualbox_5_0.IEventSource(retVal, port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
The ID VirtualBox internally assigned to the open file.
@return Long
*/
    public Long getId()
    {
        try
        {
            Long retVal = port.iFileGetId(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
The initial size in bytes when opened.
@return Long
*/
    public Long getInitialSize()
    {
        try
        {
            Long retVal = port.iFileGetInitialSize(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
The current file position.

The file current position always applies to the{@link org.virtualbox_5_0.IFile#read(Long,Long)}method, which updates it upon return.  Same goes for the{@link org.virtualbox_5_0.IFile#write(byte[],Long)}method except when{@link org.virtualbox_5_0.IFile#getAccessMode()}is{@link org.virtualbox_5_0.FileAccessMode#AppendOnly}or{@link org.virtualbox_5_0.FileAccessMode#AppendRead}, where it will always write
to the end of the file and will leave this attribute unchanged.

The{@link org.virtualbox_5_0.IFile#seek(Long,org.virtualbox_5_0.FileSeekOrigin)}is used to change this attribute without
transfering any file data like read and write does.
@return Long
*/
    public Long getOffset()
    {
        try
        {
            Long retVal = port.iFileGetOffset(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Current file status.
@return org.virtualbox_5_0.FileStatus
*/
    public org.virtualbox_5_0.FileStatus getStatus()
    {
        try
        {
            org.virtualbox_5_0.jaxws.FileStatus retVal = port.iFileGetStatus(obj);
            return org.virtualbox_5_0.FileStatus.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Full path of the actual file name of this file.
@return String
*/
    public String getFileName()
    {
        try
        {
            String retVal = port.iFileGetFileName(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
The UNIX-style creation mode specified when opening the file.
@return Long
*/
    public Long getCreationMode()
    {
        try
        {
            Long retVal = port.iFileGetCreationMode(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
The opening action specified when opening the file.
@return org.virtualbox_5_0.FileOpenAction
*/
    public org.virtualbox_5_0.FileOpenAction getOpenAction()
    {
        try
        {
            org.virtualbox_5_0.jaxws.FileOpenAction retVal = port.iFileGetOpenAction(obj);
            return org.virtualbox_5_0.FileOpenAction.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
The file access mode.
@return org.virtualbox_5_0.FileAccessMode
*/
    public org.virtualbox_5_0.FileAccessMode getAccessMode()
    {
        try
        {
            org.virtualbox_5_0.jaxws.FileAccessMode retVal = port.iFileGetAccessMode(obj);
            return org.virtualbox_5_0.FileAccessMode.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
    public static IFile queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IFile(obj.getWrapped(), obj.getRemoteWSPort());
    }

/**
Closes this file. After closing operations like reading data,
writing data or querying information will not be possible anymore.
*/
    public void close()
    {
        try
        {
        port.iFileClose(obj);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Queries information about this file.
@return Object information of this file. Also see{@link org.virtualbox_5_0.IFsObjInfo}.

Expected result codes:
<table summary="">
<tr><td>E_NOTIMPL</td><td>The method is not implemented yet.</td></tr>
</table>

*/
    public org.virtualbox_5_0.IFsObjInfo queryInfo()
    {
        try
        {
            String retVal;
        retVal = port.iFileQueryInfo(obj);
            return (retVal.length() > 0) ? new org.virtualbox_5_0.IFsObjInfo(retVal, port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Queries the current file size.
@return Queried file size.

Expected result codes:
<table summary="">
<tr><td>E_NOTIMPL</td><td>The method is not implemented yet.</td></tr>
</table>

*/
    public Long querySize()
    {
        try
        {
            Long retVal;
        retVal = port.iFileQuerySize(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Reads data from this file.
@param toRead Number of bytes to read.

@param timeoutMS Timeout (in ms) to wait for the operation to complete.
Pass 0 for an infinite timeout.

@return Array of data read.

Expected result codes:
<table summary="">
<tr><td>E_NOTIMPL</td><td>The method is not implemented yet.</td></tr>
</table>

*/
    public byte[] read(Long toRead, Long timeoutMS)
    {
        try
        {
            /*base64*/String retVal;
        retVal = port.iFileRead(obj, toRead, timeoutMS);
            return Helper.decodeBase64(retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Reads data from an offset of this file.
@param offset Offset in bytes to start reading.

@param toRead Number of bytes to read.

@param timeoutMS Timeout (in ms) to wait for the operation to complete.
Pass 0 for an infinite timeout.

@return Array of data read.

Expected result codes:
<table summary="">
<tr><td>E_NOTIMPL</td><td>The method is not implemented yet.</td></tr>
</table>

*/
    public byte[] readAt(Long offset, Long toRead, Long timeoutMS)
    {
        try
        {
            /*base64*/String retVal;
        retVal = port.iFileReadAt(obj, offset, toRead, timeoutMS);
            return Helper.decodeBase64(retVal);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Changes the current file position of this file.

The file current position always applies to the{@link org.virtualbox_5_0.IFile#read(Long,Long)}method.  Same for the{@link org.virtualbox_5_0.IFile#write(byte[],Long)}method it except when
the{@link org.virtualbox_5_0.IFile#getAccessMode()}is{@link org.virtualbox_5_0.FileAccessMode#AppendOnly}or{@link org.virtualbox_5_0.FileAccessMode#AppendRead}.
@param offset Offset to seek relative to the position specified by  whence.

@param whence One of the{@link org.virtualbox_5_0.FileSeekOrigin}seek starting points.

@return The new file offset after the seek operation.

*/
    public Long seek(Long offset, org.virtualbox_5_0.FileSeekOrigin whence)
    {
        try
        {
            Long retVal;
        retVal = port.iFileSeek(obj, offset, org.virtualbox_5_0.jaxws.FileSeekOrigin.fromValue(whence.name()));
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Sets the ACL of this file.
@param acl The ACL specification string. To-be-defined.

@param mode UNIX-style mode mask to use if  acl is empty. As mention in{@link org.virtualbox_5_0.IGuestSession#directoryCreate(String,Long,List)}this is realized on
a best effort basis and the exact behavior depends on the Guest OS.

Expected result codes:
<table summary="">
<tr><td>E_NOTIMPL</td><td>The method is not implemented yet.</td></tr>
</table>

*/
    public void setACL(String acl, Long mode)
    {
        try
        {
        port.iFileSetACL(obj, acl, mode);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Changes the file size.
@param size The new file size.

Expected result codes:
<table summary="">
<tr><td>E_NOTIMPL</td><td>The method is not implemented yet.</td></tr>
</table>

*/
    public void setSize(Long size)
    {
        try
        {
        port.iFileSetSize(obj, size);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Writes bytes to this file.
@param data Array of bytes to write. The size of the array also specifies
how much to write.

@param timeoutMS Timeout (in ms) to wait for the operation to complete.
Pass 0 for an infinite timeout.

@return How much bytes were written.

*/
    public Long write(byte[] data, Long timeoutMS)
    {
        try
        {
            Long retVal;
        retVal = port.iFileWrite(obj, Helper.encodeBase64(data), timeoutMS);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }

/**
Writes bytes at a certain offset to this file.
@param offset Offset in bytes to start writing.

@param data Array of bytes to write. The size of the array also specifies
how much to write.

@param timeoutMS Timeout (in ms) to wait for the operation to complete.
Pass 0 for an infinite timeout.

@return How much bytes were written.

Expected result codes:
<table summary="">
<tr><td>E_NOTIMPL</td><td>The method is not implemented yet.</td></tr>
</table>

*/
    public Long writeAt(Long offset, byte[] data, Long timeoutMS)
    {
        try
        {
            Long retVal;
        retVal = port.iFileWriteAt(obj, offset, Helper.encodeBase64(data), timeoutMS);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.port);
        }
    }
}
