/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.news.viewmodel;

import org.ruyisdk.news.Activator;
import org.ruyisdk.news.model.NewsFetchService;
import org.ruyisdk.news.model.NewsItem;
import org.ruyisdk.news.util.MarkdownRenderer;
import org.ruyisdk.ruyi.util.RuyiLogger;

public class NewsDetailsViewModel {
    private static final RuyiLogger LOGGER = Activator.getLogger();
    private NewsFetchService service;
    private boolean isFetching = false;

    public NewsDetailsViewModel(NewsFetchService service) {
        this.service = service;
    }

    public void onAcquireNewsDetails(NewsItem selected) {
        if (selected.getDetailsFetched()) {
            return;
        }
        if (this.isFetching) {
            return;
        }
        LOGGER.logInfo("News details requested: id=" + selected.getId());
        selected.setUnread(false);
        selected.setDetailsHtml(MarkdownRenderer.renderToHtml("*fetching news details...*"));
        this.isFetching = true;
        this.service.fetchNewsDetailsAsync(selected.getId(), result -> {
            this.isFetching = false;
            String markdown = result == null ? "" : result;
            selected.setDetails(markdown);
            selected.setDetailsHtml(MarkdownRenderer.renderToHtml(markdown));
            selected.setDetailsFetched(true);
        }, result -> {
            this.isFetching = false;
            String errorMarkdown = "*failed to fetch news details: " + result + "*";
            selected.setDetails(errorMarkdown);
            selected.setDetailsHtml(MarkdownRenderer.renderToHtml(errorMarkdown));
            selected.setDetailsFetched(false);
        });
    }
}

