/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.news.util;

import java.util.List;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public final class MarkdownRenderer {
    private static final List<Extension> EXTENSIONS = List.of(TablesExtension.create());
    private static final Parser PARSER = Parser.builder().extensions(EXTENSIONS).build();
    private static final HtmlRenderer HTML_RENDERER = HtmlRenderer.builder().extensions(EXTENSIONS).build();
    private static final String HTML_TEMPLATE = "<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"UTF-8\">\n<style>\nbody {\n    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif;\n    font-size: 14px;\n    line-height: 1.6;\n    padding: 10px;\n    margin: 0;\n}\ntable {\n    border-collapse: collapse;\n    width: 100%%;\n    margin: 10px 0;\n}\nth, td {\n    border: 1px solid #ddd;\n    padding: 8px;\n    text-align: left;\n}\nth {\n    background-color: #f4f4f4;\n}\na {\n    color: #0066cc;\n}\ncode {\n    background-color: #f4f4f4;\n    padding: 2px 4px;\n    border-radius: 3px;\n    font-family: monospace;\n}\npre {\n    background-color: #f4f4f4;\n    padding: 10px;\n    border-radius: 5px;\n    overflow-x: auto;\n}\npre code {\n    padding: 0;\n    background-color: transparent;\n}\nblockquote {\n    border-left: 4px solid #ddd;\n    margin: 0;\n    padding-left: 16px;\n    color: #666;\n}\n</style>\n</head>\n<body>\n%s\n</body>\n</html>\n";

    public static String renderToHtml(String markdown) {
        if (markdown == null || markdown.isEmpty()) {
            return String.format(HTML_TEMPLATE, "");
        }
        Node document = PARSER.parse(markdown);
        String htmlContent = HTML_RENDERER.render(document);
        return String.format(HTML_TEMPLATE, htmlContent);
    }
}

