/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.news.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.ruyisdk.news.model.NewsItem;

public class NewsManager {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final List<NewsItem> newsList = new ArrayList<NewsItem>();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addNews(NewsItem news) {
        this.newsList.add(news);
        this.pcs.firePropertyChange("newsList", null, this.newsList);
    }

    public void removeNews(NewsItem news) {
        this.newsList.remove(news);
        this.pcs.firePropertyChange("newsList", null, this.newsList);
    }

    public List<NewsItem> getNewsList() {
        return new ArrayList<NewsItem>(this.newsList);
    }

    public void updateNews(NewsItem oldNews, NewsItem newNews) {
        int index = this.newsList.indexOf(oldNews);
        if (index != -1) {
            this.newsList.set(index, newNews);
            this.pcs.firePropertyChange("newsList", null, this.newsList);
        }
    }
}

