/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.news.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.ruyisdk.news.Activator;
import org.ruyisdk.news.model.NewsItem;
import org.ruyisdk.ruyi.services.RuyiCli;
import org.ruyisdk.ruyi.util.RuyiLogger;

public class NewsFetchService {
    private static final RuyiLogger LOGGER = Activator.getLogger();

    public void fetchNewsDetailsAsync(final String id, final Consumer<String> callback, final Consumer<String> errorCallback) {
        Job fetchJob = new Job("Fetching News Details"){

            protected IStatus run(IProgressMonitor monitor) {
                LOGGER.logInfo("Fetching news details: id=" + id);
                String result = "";
                try {
                    RuyiCli.NewsReadResult read = RuyiCli.readNewsItem((String)id);
                    if (read == null) {
                        throw new Exception("timed out");
                    }
                    result = read.getContent() == null ? "" : read.getContent();
                    LOGGER.logInfo("Fetched news details: id=" + id + ", length=" + result.length());
                }
                catch (Exception e) {
                    String msg = e.getMessage() == null ? "Failed to read news details" : e.getMessage();
                    LOGGER.logError("Failed to fetch news details: id=" + id, (Throwable)e);
                    if (errorCallback != null) {
                        errorCallback.accept(msg);
                    }
                    return Status.CANCEL_STATUS;
                }
                callback.accept(result);
                return Status.OK_STATUS;
            }
        };
        fetchJob.schedule();
    }

    public void fetchNewsListAsync(Consumer<List<NewsItem>> callback) {
        this.fetchNewsListAsync(callback, null);
    }

    public void fetchNewsListAsync(final Consumer<List<NewsItem>> callback, final Consumer<String> errorCallback) {
        Job fetchJob = new Job("Fetching News List"){

            protected IStatus run(IProgressMonitor monitor) {
                ArrayList<NewsItem> newsList;
                block4: {
                    LOGGER.logInfo("Fetching news list");
                    newsList = new ArrayList<NewsItem>();
                    try {
                        int unreadCount = 0;
                        for (RuyiCli.NewsListItemInfo item : RuyiCli.listNewsItems((boolean)false)) {
                            Integer ordObj;
                            boolean unread;
                            if (item == null) continue;
                            Boolean isRead = item.isRead();
                            boolean bl = unread = isRead == null || isRead == false;
                            if (unread) {
                                ++unreadCount;
                            }
                            int ord = (ordObj = item.getOrd()) == null ? -1 : ordObj;
                            String title = item.getTitle() == null ? "" : item.getTitle();
                            String id = item.getId() == null ? "" : item.getId();
                            newsList.add(new NewsItem(ord, title, id, unread));
                        }
                        LOGGER.logInfo("Fetched news list: count=" + newsList.size() + ", unread=" + unreadCount);
                    }
                    catch (Exception e) {
                        String msg = e.getMessage() == null ? "Failed to list news" : e.getMessage();
                        LOGGER.logError("Failed to fetch news list", (Throwable)e);
                        if (errorCallback == null) break block4;
                        errorCallback.accept(msg);
                    }
                }
                callback.accept(newsList);
                return Status.OK_STATUS;
            }
        };
        fetchJob.schedule();
    }
}

