/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.projectcreator.wizards;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.ruyisdk.projectcreator.utils.ToolchainLocator;
import org.ruyisdk.projectcreator.wizards.NewProjectWizard;

public class ProjectSettingsPage
extends WizardPage {
    private Text projectNameText;
    private Text toolchainPathText;
    private Text cflagsText;
    private String boardModel;

    protected ProjectSettingsPage(String pageName) {
        super(pageName);
        this.setTitle("Project Settings");
        this.setDescription("Set the project name and toolchain configuration.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        new Label(container, 0).setText("Project Name:");
        this.projectNameText = new Text(container, 2052);
        this.projectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.projectNameText.addModifyListener(e -> this.validatePage());
        new Label(container, 0).setText("Toolchain Path:");
        this.toolchainPathText = new Text(container, 2052);
        this.toolchainPathText.setLayoutData((Object)new GridData(768));
        this.toolchainPathText.addModifyListener(e -> this.validatePage());
        Button browseButton = new Button(container, 8);
        browseButton.setText("Browse...");
        browseButton.addListener(13, e -> {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            dialog.setText("Select Toolchain Root Directory");
            dialog.setFilterPath(this.toolchainPathText.getText());
            String path = dialog.open();
            if (path != null) {
                this.toolchainPathText.setText(path);
            }
        });
        new Label(container, 0).setText("C Compiler Flags (CFLAGS):");
        this.cflagsText = new Text(container, 2052);
        this.cflagsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cflagsText.setText("-Wall -O2 -march=rv64imac -mabi=lp64");
        this.validatePage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            NewProjectWizard wizard = (NewProjectWizard)this.getWizard();
            this.boardModel = wizard.getBoardModel();
            this.updateToolchainPath();
            this.validatePage();
        }
    }

    private void updateToolchainPath() {
        String detectedPath = ToolchainLocator.findToolchainPathForBoard(this.boardModel);
        if (detectedPath != null) {
            this.toolchainPathText.setText(detectedPath);
        } else {
            String lastUsed = ToolchainLocator.getLastUsedPath();
            this.toolchainPathText.setText(lastUsed != null ? lastUsed : "");
        }
    }

    private void validatePage() {
        String projectName = this.projectNameText.getText().trim();
        if (projectName.isEmpty()) {
            this.setErrorMessage("Project Name cannot be empty.");
            this.setPageComplete(false);
            return;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
        if (!status.isOK()) {
            this.setErrorMessage("Project name contains invalid characters.");
            this.setPageComplete(false);
            return;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
            this.setErrorMessage("Project \"" + projectName + "\" already exists.");
            this.setPageComplete(false);
            return;
        }
        if (this.toolchainPathText.getText().trim().isEmpty()) {
            this.setErrorMessage("Toolchain Path cannot be empty.");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public String getProjectName() {
        return this.projectNameText.getText().trim();
    }

    public String getToolchainPath() {
        return this.toolchainPathText.getText().trim();
    }

    public String getCflags() {
        if (this.cflagsText != null && !this.cflagsText.isDisposed()) {
            return this.cflagsText.getText();
        }
        return "";
    }
}

