/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.projectcreator.wizards;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.Bundle;
import org.ruyisdk.projectcreator.Activator;
import org.ruyisdk.projectcreator.utils.ToolchainLocator;
import org.ruyisdk.projectcreator.wizards.BoardSelectionPage;
import org.ruyisdk.projectcreator.wizards.ProjectSettingsPage;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private BoardSelectionPage boardSelectionPage;
    private ProjectSettingsPage projectSettingsPage;
    private IWorkbench workbench;

    public NewProjectWizard() {
        this.setWindowTitle("new RuyiSDK Project");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void addPages() {
        this.boardSelectionPage = new BoardSelectionPage("Select Board");
        this.projectSettingsPage = new ProjectSettingsPage("Project Settings");
        this.addPage((IWizardPage)this.boardSelectionPage);
        this.addPage((IWizardPage)this.projectSettingsPage);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.projectSettingsPage && this.projectSettingsPage.isPageComplete();
    }

    public boolean performFinish() {
        String boardModel = this.boardSelectionPage.getBoardModel();
        String projectName = this.projectSettingsPage.getProjectName();
        String toolchainPath = this.projectSettingsPage.getToolchainPath();
        String cflags = this.projectSettingsPage.getCflags();
        if (toolchainPath == null || toolchainPath.trim().isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"toolchainPath Cannot be empty");
            return false;
        }
        String templateToUse = boardModel;
        Bundle bundle = Activator.getDefault().getBundle();
        URL templateDirUrl = bundle.getEntry("/templates/" + boardModel);
        if (templateDirUrl == null) {
            boolean useDefault = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Template Not Found", (String)(boardModel + "\" demo is not found\n\nare you want to use the default template?"));
            if (useDefault) {
                templateToUse = "default";
            } else {
                return false;
            }
        }
        String finalTemplateName = templateToUse;
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    this.createProject(projectName, boardModel, toolchainPath, cflags, finalTemplateName, monitor);
                }
                catch (IOException | CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
            ToolchainLocator.saveLastUsedToolchainPath(toolchainPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"create project failed", (String)e.getMessage());
            return false;
        }
        return true;
    }

    public String getBoardModel() {
        if (this.boardSelectionPage != null) {
            return this.boardSelectionPage.getBoardModel();
        }
        return "";
    }

    private void createProject(String projectName, String boardModel, String toolchainPath, String cflags, String templateName, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask("Creating project " + projectName, 4);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project.create(monitor);
        project.open(monitor);
        monitor.worked(1);
        IProjectDescription description = project.getDescription();
        description.setBuildSpec(new ICommand[0]);
        description.setNatureIds(new String[]{"org.ruyisdk.projectcreator.projectNature"});
        project.setDescription(description, monitor);
        monitor.worked(1);
        this.copyTemplateFiles(project, templateName, toolchainPath, cflags, monitor);
        monitor.worked(1);
        project.setPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", "boardModel"), boardModel);
        project.setPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", "toolchainPath"), toolchainPath);
        project.setPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", "buildCmd"), "make");
        project.setPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", "cflags"), cflags);
        project.refreshLocal(2, monitor);
        monitor.worked(1);
    }

    /*
     * Unable to fully structure code
     */
    private void copyTemplateFiles(IProject project, String templateName, String toolchainRootPath, String cflags, IProgressMonitor monitor) throws CoreException, IOException {
        bundle = Activator.getDefault().getBundle();
        entries = bundle.findEntries(templatePath = "/templates/" + templateName, "*", true);
        if (entries != null) ** GOTO lbl90
        throw new CoreException((IStatus)new Status(4, "org.ruyisdk.projectcreator", "Template not found: " + templatePath));
lbl-1000:
        // 1 sources

        {
            entryUrl = (URL)entries.nextElement();
            entryPath = entryUrl.getPath();
            targetPath = entryPath.substring(templatePath.length());
            if (targetPath.isEmpty() || targetPath.equals("/")) continue;
            if (entryPath.endsWith("/")) {
                folder = project.getFolder(targetPath);
                if (folder.exists()) continue;
                folder.create(true, true, monitor);
                continue;
            }
            file = project.getFile(targetPath);
            if (file.getName().equals("Makefile")) {
                toolchainBinPath = Paths.get(toolchainRootPath, new String[]{"bin"}).toString();
                toolchainPrefixName = this.findToolchainPrefixName(toolchainRootPath);
                if (toolchainPrefixName == null) {
                    toolchainPrefixName = "riscv64-unknown-elf";
                    System.err.println("Warning: Failed to infer toolchain prefix name from '" + toolchainRootPath + "', using default value: " + toolchainPrefixName);
                }
                sb = new StringBuilder();
                var16_18 = null;
                var17_20 = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(entryUrl.openStream(), StandardCharsets.UTF_8));
                    try {
                        while ((line = reader.readLine()) != null) {
                            line = line.replace("__TOOLCHAIN_BIN_PATH__", toolchainBinPath);
                            line = line.replace("__TOOLCHAIN_PREFIX_NAME__", toolchainPrefixName);
                            line = line.replace("__CFLAGS_OPTIONS__", cflags);
                            sb.append(line).append(System.lineSeparator());
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (Throwable var17_21) {
                    if (var16_18 == null) {
                        var16_18 = var17_21;
                    } else if (var16_18 != var17_21) {
                        var16_18.addSuppressed(var17_21);
                    }
                    throw var16_18;
                }
                finalContent = sb.toString();
                var17_20 = null;
                var18_23 = null;
                try {
                    newContentStream = new ByteArrayInputStream(finalContent.getBytes(StandardCharsets.UTF_8));
                    try {
                        if (file.exists()) {
                            file.setContents((InputStream)newContentStream, true, true, monitor);
                            continue;
                        }
                        file.create((InputStream)newContentStream, true, monitor);
                        continue;
                    }
                    finally {
                        if (newContentStream != null) {
                            newContentStream.close();
                        }
                    }
                }
                catch (Throwable var18_24) {
                    if (var17_20 == null) {
                        var17_20 = var18_24;
                    } else if (var17_20 != var18_24) {
                        var17_20.addSuppressed(var18_24);
                    }
                    throw var17_20;
                }
            }
            var13_13 = null;
            var14_15 = null;
            try {
                is = entryUrl.openStream();
                try {
                    if (file.exists()) {
                        file.setContents(is, true, true, monitor);
                        continue;
                    }
                    file.create(is, true, monitor);
                    continue;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable var14_16) {
                if (var13_13 == null) {
                    var13_13 = var14_16;
                } else if (var13_13 != var14_16) {
                    var13_13.addSuppressed(var14_16);
                }
                throw var13_13;
            }
lbl90:
            // 8 sources

            ** while (entries.hasMoreElements())
        }
lbl91:
        // 1 sources

    }

    private String findToolchainPrefixName(String toolchainRootPath) {
        File binDir = new File(toolchainRootPath, "bin");
        if (!binDir.isDirectory()) {
            return null;
        }
        File[] files = binDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                if (name.endsWith("-gcc") && file.isFile()) {
                    return name.substring(0, name.length() - "-gcc".length());
                }
                ++n2;
            }
        }
        return null;
    }
}

