/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.projectcreator.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;

public class BuildLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IProject) {
            this.launchProject((IProject)element, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
    }

    private void launchProject(IProject project, String mode) {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
            if (type == null) {
                System.err.println("Launch configuration type not found: org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
                return;
            }
            String configName = launchManager.generateLaunchConfigurationName("Build " + project.getName());
            ILaunchConfigurationWorkingCopy wc = type.newInstance(null, configName);
            String toolchainPath = project.getPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", "toolchainPath"));
            String buildCmd = project.getPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", "buildCmd"));
            if (buildCmd == null || toolchainPath == null) {
                return;
            }
            String command = "make";
            String args = "";
            int firstSpace = buildCmd.indexOf(32);
            if (firstSpace > 0) {
                args = buildCmd.substring(firstSpace + 1);
            }
            String commandPath = toolchainPath + "/bin/" + command;
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", commandPath);
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", project.getLocation().toOSString());
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
            wc.setAttribute("org.eclipse.debug.core.capture_output", true);
            ILaunchConfiguration config = wc.doSave();
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

