/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.projectcreator.builder;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.ruyisdk.packages.JsonParser;

public class MakefileBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.ruyisdk.projectcreator.makefileBuilder";
    private static final String BUILD_CMD_PROPERTY = "buildCmd";
    private static final String BOARD_MODEL_PROPERTY = "boardModel";
    private static final String OBJ_DIR_NAME = "obj";
    private static final String LOG_FILE_NAME = "build_output.log";
    private static final String RUYI_VENV_DIR = "ruyiVenv";
    public static final String RUYI_VENV_CMD_PROPERTY = "ruyiVenvCmd";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        File projectLocation = project.getLocation().toFile();
        IFolder objFolder = project.getFolder(OBJ_DIR_NAME);
        if (!objFolder.exists()) {
            objFolder.create(true, true, monitor);
        }
        this.clearLogFile(project);
        this.logToFile(project, "=== Build started at " + String.valueOf(new Date()) + " ===");
        try {
            this.ensureRuyiVenv(project, monitor);
        }
        catch (IOException | InterruptedException e) {
            String errorMsg = "Failed to create Ruyi virtual environment: " + e.getMessage();
            this.logToFile(project, errorMsg);
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "org.ruyisdk.projectcreator", errorMsg, (Throwable)e));
        }
        String buildCommand = project.getPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", BUILD_CMD_PROPERTY));
        if (buildCommand == null || buildCommand.trim().isEmpty()) {
            buildCommand = "make";
        }
        this.logToFile(project, "Project: " + project.getName());
        File venvBinDir = new File(projectLocation, "ruyiVenv/bin");
        String gccPath = this.findRiscvGcc(venvBinDir);
        if (gccPath == null) {
            String errorMsg = "Could not find RISC-V GCC in Ruyi virtual environment at: " + venvBinDir.getAbsolutePath();
            this.logToFile(project, errorMsg);
            throw new CoreException((IStatus)new Status(4, "org.ruyisdk.projectcreator", errorMsg));
        }
        this.logToFile(project, "Found RISC-V GCC at: " + gccPath);
        String gccName = new File(gccPath).getName();
        String prefix = gccName.replace("-gcc", "");
        this.logToFile(project, "Using toolchain prefix: " + prefix);
        String cflags = this.determineCorrectCflags(gccPath, project);
        this.logToFile(project, "Using CFLAGS: " + cflags);
        try {
            try {
                ArrayList<String> commands = new ArrayList<String>();
                commands.add("bash");
                commands.add("-c");
                String makeCmd = String.format("cd %s && %s CC=%s/%s-gcc OBJCOPY=%s/%s-objcopy 'CFLAGS=%s'", projectLocation.getAbsolutePath(), buildCommand, venvBinDir.getAbsolutePath(), prefix, venvBinDir.getAbsolutePath(), prefix, cflags);
                commands.add(makeCmd);
                this.logToFile(project, "Build command: " + makeCmd);
                ProcessBuilder processBuilder = new ProcessBuilder(commands);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                Throwable throwable = null;
                Object var18_25 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        System.out.println(">>> MakefileBuilder: " + line);
                        this.logToFile(project, line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                int exitCode = process.waitFor();
                String resultMessage = "Build finished with exit code: " + exitCode;
                this.logToFile(project, resultMessage);
            }
            catch (Exception e) {
                String errorMessage = "Build failed with exception: " + e.getMessage();
                System.err.println(">>> MakefileBuilder: " + errorMessage);
                e.printStackTrace();
                this.logToFile(project, errorMessage);
                this.logToFile(project, "=== Build finished at " + String.valueOf(new Date()) + " ===");
                project.refreshLocal(2, monitor);
                monitor.done();
            }
        }
        finally {
            this.logToFile(project, "=== Build finished at " + String.valueOf(new Date()) + " ===");
            project.refreshLocal(2, monitor);
            monitor.done();
        }
        return null;
    }

    private String determineCorrectCflags(String gccPath, IProject project) throws CoreException {
        String cflags = "-Wall -O2";
        String boardModel = project.getPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", BOARD_MODEL_PROPERTY));
        if (boardModel == null || boardModel.trim().isEmpty()) {
            return cflags;
        }
        if (gccPath.contains("unknown-linux-musl")) {
            return cflags + " -march=rv64gc -mabi=lp64d";
        }
        if (gccPath.contains("unknown-linux-gnu")) {
            return cflags + " -march=rv64gc -mabi=lp64d";
        }
        if (gccPath.contains("milkv-duo-elf")) {
            return cflags + " -march=rv64gc -mabi=lp64d";
        }
        if (gccPath.contains("unknown-elf") || gccPath.contains("plct-elf")) {
            if ("milkv-duo".equals(boardModel)) {
                return cflags + " -march=rv64gc -mabi=lp64d";
            }
            return cflags + " -march=rv64imac -mabi=lp64";
        }
        return cflags + " -march=rv64gc -mabi=lp64d";
    }

    private String findRiscvGcc(File directory) {
        if (!directory.exists() || !directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles(file -> {
            String name = file.getName();
            return (name.startsWith("riscv") || name.contains("-riscv")) && name.endsWith("-gcc");
        });
        if (files != null && files.length > 0) {
            return files[0].getAbsolutePath();
        }
        return null;
    }

    private String getRuyiInstallPath() {
        try {
            Class<?> clazz = Class.forName("org.ruyisdk.ruyi.util.RuyiFileUtils");
            Method method = clazz.getMethod("getInstallPath", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return System.getProperty("user.home") + "/.ruyi";
        }
    }

    private void ensureRuyiVenv(IProject project, IProgressMonitor monitor) throws IOException, InterruptedException, CoreException {
        Object ruyiPath;
        File projectLocation = project.getLocation().toFile();
        File venvDir = new File(projectLocation, RUYI_VENV_DIR);
        if (venvDir.exists() && venvDir.isDirectory()) {
            this.logToFile(project, "Ruyi virtual environment found at: " + venvDir.getAbsolutePath());
            return;
        }
        this.logToFile(project, "Ruyi virtual environment not found. Creating...");
        String venvCommand = project.getPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", RUYI_VENV_CMD_PROPERTY));
        if (venvCommand == null || venvCommand.trim().isEmpty()) {
            this.logToFile(project, "No custom venv command found, generating default command...");
            String boardModel = project.getPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", BOARD_MODEL_PROPERTY));
            if (boardModel == null) {
                throw new CoreException((IStatus)new Status(4, "org.ruyisdk.projectcreator", "Board model not set for project."));
            }
            String toolchain = JsonParser.findInstalledToolchainForBoard((String)boardModel);
            if (toolchain == null || toolchain.trim().isEmpty()) {
                toolchain = "milkv-duo".equals(boardModel) ? "gnu-milkv-milkv-duo-elf-bin" : ("sipeed-lpi4a".equals(boardModel) ? "gnu-plct-xthead" : "gnu-plct");
            } else {
                int versionIndex = toolchain.indexOf("-0.");
                if (versionIndex > 0) {
                    toolchain = toolchain.substring(0, versionIndex);
                }
            }
            ruyiPath = this.getRuyiInstallPath() + "/ruyi";
            venvCommand = String.format("%s venv -t %s %s ./%s", ruyiPath, toolchain, boardModel, RUYI_VENV_DIR);
        } else {
            this.logToFile(project, "Using custom ruyi venv command from project properties.");
        }
        ProcessBuilder pb = new ProcessBuilder("bash", "-c", venvCommand);
        System.err.println("Executing: " + venvCommand);
        pb.directory(projectLocation);
        pb.redirectErrorStream(true);
        this.logToFile(project, "Executing: " + venvCommand);
        Process process = pb.start();
        ruyiPath = null;
        Object var9_12 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.logToFile(project, "[ruyi venv] " + line);
            }
        }
        catch (Throwable throwable) {
            if (ruyiPath == null) {
                ruyiPath = throwable;
            } else if (ruyiPath != throwable) {
                ((Throwable)ruyiPath).addSuppressed(throwable);
            }
            throw ruyiPath;
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new CoreException((IStatus)new Status(4, "org.ruyisdk.projectcreator", "Failed to create Ruyi virtual environment. Exit code: " + exitCode));
        }
    }

    private void clearLogFile(IProject project) {
        IFolder objFolder = project.getFolder(OBJ_DIR_NAME);
        IFile logFile = objFolder.getFile(LOG_FILE_NAME);
        try {
            if (!objFolder.exists()) {
                objFolder.create(1, true, null);
            }
            if (logFile.exists()) {
                logFile.delete(true, null);
            }
        }
        catch (CoreException e) {
            System.err.println(">>> MakefileBuilder: Failed to clear log file: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logToFile(IProject project, String message) {
        IFolder objFolder = project.getFolder(OBJ_DIR_NAME);
        IFile logFile = objFolder.getFile(LOG_FILE_NAME);
        try {
            Object var6_9;
            Throwable throwable;
            if (!objFolder.exists()) {
                objFolder.create(1, true, null);
            }
            if (!logFile.exists()) {
                throwable = null;
                var6_9 = null;
                try (ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);){
                    logFile.create((InputStream)stream, true, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    } else {
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            throwable = null;
            var6_9 = null;
            try {
                FileWriter writer = new FileWriter(logFile.getLocation().toFile(), true);
                try {
                    try (PrintWriter printWriter = new PrintWriter(writer);){
                        printWriter.println(message);
                    }
                    if (writer == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
                writer.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            System.err.println(">>> MakefileBuilder: Failed to write to log file: " + e.getMessage());
        }
    }
}

