/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.projectcreator;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.ruyisdk.projectcreator";
    private static Activator plugin;
    private IResourceChangeListener buildListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            this.getBundle().loadClass("org.ruyisdk.projectcreator.builder.MakefileBuilder");
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.buildListener = event -> {
                switch (event.getType()) {
                    case 8: {
                        if (!(event.getSource() instanceof IProject)) break;
                        IProject project = (IProject)event.getSource();
                        System.out.println(">>> Activator: Building project: " + project.getName());
                        try {
                            IProjectDescription desc = project.getDescription();
                            ICommand[] commands = desc.getBuildSpec();
                            System.out.println(">>> Activator: Project builders:");
                            ICommand[] iCommandArray = commands;
                            int n = commands.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ICommand cmd = iCommandArray[n2];
                                System.out.println(">>>   - " + cmd.getBuilderName());
                                ++n2;
                            }
                        }
                        catch (CoreException e) {
                            System.err.println(">>> Activator: Failed to add Makefile builder: " + e.getMessage());
                        }
                        break;
                    }
                }
            };
            workspace.addResourceChangeListener(this.buildListener, 28);
            System.out.println(">>> Activator: Build listener registered successfully");
        }
        catch (Exception e) {
            System.err.println(">>> Activator: Error during plugin initialization!");
            e.printStackTrace();
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.buildListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.buildListener);
            System.out.println(">>> Activator: Build listener unregistered");
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

