/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.core.ruyi.model;

public class RuyiVersion
implements Comparable<RuyiVersion> {
    private final int major;
    private final int minor;
    private final int patch;

    public RuyiVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static RuyiVersion parse(String versionStr) {
        String[] parts;
        block3: {
            try {
                parts = versionStr.split("\\.");
                if (parts.length == 3) break block3;
                System.out.print("Invalid version format: " + versionStr);
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.print("Invalid version number: " + versionStr);
                return null;
            }
        }
        return new RuyiVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }

    @Override
    public int compareTo(RuyiVersion other) {
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        return Integer.compare(this.patch, other.patch);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }
}

