/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.core.ruyi.model;

import org.ruyisdk.core.ruyi.model.RuyiVersion;

public class CheckResult {
    private final ActionType action;
    private final String message;
    private final RuyiVersion currentVersion;
    private final RuyiVersion latestVersion;

    private CheckResult(ActionType action, String message, RuyiVersion current, RuyiVersion latest) {
        this.action = action;
        this.message = message;
        this.currentVersion = current;
        this.latestVersion = latest;
    }

    public static CheckResult needInstall(String msg) {
        return new CheckResult(ActionType.INSTALL, msg, null, null);
    }

    public static CheckResult needUpgrade(RuyiVersion current, RuyiVersion latest, String msg) {
        return new CheckResult(ActionType.UPGRADE, msg, current, latest);
    }

    public static CheckResult ok() {
        return new CheckResult(ActionType.NOTHING, "Ruyi is up-to-date", null, null);
    }

    public ActionType getAction() {
        return this.action;
    }

    public String getMessage() {
        return this.message;
    }

    public RuyiVersion getCurrentVersion() {
        return this.currentVersion;
    }

    public RuyiVersion getLatestVersion() {
        return this.latestVersion;
    }

    public boolean needAction() {
        return this.action != ActionType.NOTHING;
    }

    public static enum ActionType {
        INSTALL,
        UPGRADE,
        NOTHING;

    }
}

