/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.core.console;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class RuyiSdkConsole {
    private static final String CONSOLE_NAME = "RuyiSDK";
    private static final String CONSOLE_TYPE = "org.ruyisdk.console";
    private final MessageConsole console = new MessageConsole("RuyiSDK", "org.ruyisdk.console", ImageDescriptor.getMissingImageDescriptor(), true);
    private MessageConsoleStream infoStream;
    private MessageConsoleStream warnStream;
    private MessageConsoleStream errorStream;
    private MessageConsoleStream commandStream;

    private RuyiSdkConsole() {
        this.initStreams();
    }

    public static RuyiSdkConsole getInstance() {
        return Holder.INSTANCE;
    }

    public synchronized void logInfo(String message) {
        this.infoStream.println("[INFO] " + message);
    }

    public synchronized void logCommand(String message) {
        this.infoStream.println("[COMMAND] " + message);
    }

    public synchronized void logWarn(String message) {
        this.infoStream.println("[WARN] " + message);
    }

    public synchronized void logError(String message) {
        this.errorStream.println("[ERROR] " + message);
        this.errorStream.setActivateOnWrite(true);
    }

    public MessageConsole getConsole() {
        return this.console;
    }

    private void initStreams() {
        Display display = Display.getDefault();
        this.infoStream = this.console.newMessageStream();
        this.infoStream.setColor(new Color((Device)display, 0, 127, 0));
        this.warnStream = this.console.newMessageStream();
        this.warnStream.setColor(new Color((Device)display, 200, 100, 0));
        this.errorStream = this.console.newMessageStream();
        this.errorStream.setColor(new Color((Device)display, 255, 0, 0));
        this.commandStream = this.console.newMessageStream();
        this.commandStream.setColor(new Color((Device)display, 0, 0, 255));
    }

    private static class Holder {
        static final RuyiSdkConsole INSTANCE = new RuyiSdkConsole();

        private Holder() {
        }
    }
}

