/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.venv.views;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.ruyisdk.venv.viewmodel.VenvWizardViewModel;

public class WizardLocationPage
extends WizardPage {
    private final VenvWizardViewModel viewModel;
    private DataBindingContext dbc;
    private Composite container;
    private Text summaryText;
    private Text venvNameText;
    private Combo venvPathCombo;
    private ComboViewer venvPathComboViewer;
    private Button browseButton;

    WizardLocationPage(VenvWizardViewModel viewModel) {
        super("locationPage");
        this.viewModel = viewModel;
        this.setTitle("Venv Location");
        this.setDescription("Review summary and select the venv location.");
    }

    public void createControl(Composite parent) {
        this.createLayouts(parent);
        this.addControls();
        this.registerEvents();
    }

    private void createLayouts(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)this.container);
    }

    private void addControls() {
        Label summaryLabel = new Label(this.container, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        summaryLabel.setLayoutData((Object)gridData);
        summaryLabel.setText("Summary:");
        this.summaryText = new Text(this.container, 2626);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.summaryText.setLayoutData((Object)gridData);
        this.summaryText.setText(this.viewModel.getSummaryText());
        this.summaryText.setEditable(false);
        Label nameLabel = new Label(this.container, 0);
        nameLabel.setText("Venv Name:");
        this.venvNameText = new Text(this.container, 2048);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.venvNameText.setLayoutData((Object)gridData2);
        Label locationLabel = new Label(this.container, 0);
        locationLabel.setText("Venv Path:");
        this.venvPathCombo = new Combo(this.container, 2052);
        this.venvPathCombo.setLayoutData((Object)new GridData(768));
        this.venvPathCombo.setText("");
        this.venvPathComboViewer = new ComboViewer(this.venvPathCombo);
        this.browseButton = new Button(this.container, 8);
        this.browseButton.setText("Browse...");
    }

    private void registerEvents() {
        this.dbc = new DataBindingContext();
        this.container.addDisposeListener(e -> {
            if (this.dbc != null) {
                this.dbc.dispose();
                this.dbc = null;
            }
        });
        final ISWTObservableValue nameObservable = WidgetProperties.text((int)24).observe((Widget)this.venvNameText);
        final ISWTObservableValue pathObservable = WidgetProperties.comboSelection().observe((Widget)this.venvPathCombo);
        this.dbc.bindValue((IObservableValue)pathObservable, BeanProperties.value(VenvWizardViewModel.class, (String)"venvLocation", String.class).observe((Object)this.viewModel));
        this.dbc.bindValue((IObservableValue)nameObservable, BeanProperties.value(VenvWizardViewModel.class, (String)"venvName", String.class).observe((Object)this.viewModel));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.summaryText), BeanProperties.value(VenvWizardViewModel.class, (String)"summaryText", String.class).observe((Object)this.viewModel));
        ViewerSupport.bind((StructuredViewer)this.venvPathComboViewer, this.viewModel.getProjectRootPaths(), (IValueProperty)Properties.selfValue(String.class));
        this.browseButton.addListener(13, e -> {
            String selectedPath = new DirectoryDialog(this.getShell()).open();
            if (selectedPath != null) {
                this.venvPathCombo.setText(selectedPath);
            }
        });
        ComputedValue<Boolean> completeObservable = new ComputedValue<Boolean>(){

            protected Boolean calculate() {
                String path = (String)pathObservable.getValue();
                String name = (String)nameObservable.getValue();
                if (path != null && !path.isBlank() && name != null && !name.isBlank()) {
                    return true;
                }
                return false;
            }
        };
        completeObservable.addValueChangeListener(arg_0 -> this.lambda$2(completeObservable, arg_0));
        this.setPageComplete(Boolean.TRUE.equals(completeObservable.getValue()));
    }

    private /* synthetic */ void lambda$2(1 var1_1, ValueChangeEvent e) {
        this.setPageComplete(Boolean.TRUE.equals(var1_1.getValue()));
        if (this.getWizard() != null && this.getWizard().getContainer() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }
}

