/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.venv.views;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.ruyisdk.venv.model.Emulator;
import org.ruyisdk.venv.model.Profile;
import org.ruyisdk.venv.model.Toolchain;
import org.ruyisdk.venv.viewmodel.VenvWizardViewModel;

public class WizardConfigPage
extends WizardPage {
    private final VenvWizardViewModel viewModel;
    private DataBindingContext dbc;
    private Composite container;
    private Composite profileComposite;
    private Composite toolchainComposite;
    private Composite emulatorHeader;
    private Composite emulatorComposite;
    private Group sysrootGroup;
    private TableViewer profileTableViewer;
    private TableViewer toolchainNamesViewer;
    private TableViewer toolchainVersionsViewer;
    private Button emulatorCheckBox;
    private Table emulatorNames;
    private TableViewer emulatorNamesViewer;
    private Table emulatorVersions;
    private TableViewer emulatorVersionsViewer;
    private Button sysrootDefaultRadio;
    private Button sysrootNoneRadio;
    private Button sysrootForeignRadio;

    WizardConfigPage(VenvWizardViewModel viewModel) {
        super("configurationPage");
        this.viewModel = viewModel;
        this.setTitle("Venv Configuration");
        this.setDescription("Configure profile, toolchains and emulator options.");
    }

    public void createControl(Composite parent) {
        this.createLayouts(parent);
        this.addControls();
        this.registerEvents();
        this.updatePageComplete();
    }

    private void createLayouts(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.profileComposite = new Composite(this.container, 0);
        this.profileComposite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        this.profileComposite.setLayout((Layout)gridLayout);
        this.toolchainComposite = new Composite(this.container, 0);
        this.toolchainComposite.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        this.toolchainComposite.setLayout((Layout)gridLayout);
        this.emulatorHeader = new Composite(this.container, 0);
        this.emulatorHeader.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        this.emulatorHeader.setLayout((Layout)gridLayout);
        this.emulatorComposite = new Composite(this.container, 0);
        this.emulatorComposite.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        this.emulatorComposite.setLayout((Layout)gridLayout);
        this.sysrootGroup = new Group(this.container, 0);
        this.sysrootGroup.setLayoutData((Object)new GridData(768));
        this.sysrootGroup.setText("");
        gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        this.sysrootGroup.setLayout((Layout)gridLayout);
        this.setControl((Control)this.container);
    }

    private void addControls() {
        Label profileLabel = new Label(this.profileComposite, 0);
        profileLabel.setText("Profiles");
        this.profileTableViewer = new TableViewer(this.profileComposite, 67584);
        Table profileTable = this.profileTableViewer.getTable();
        GridData gridData = new GridData(768);
        gridData.heightHint = 150;
        profileTable.setLayoutData((Object)gridData);
        profileTable.setHeaderVisible(true);
        profileTable.setLinesVisible(true);
        TableViewerColumn column = new TableViewerColumn(this.profileTableViewer, 16384);
        column.getColumn().setText("Name");
        column.getColumn().setWidth(200);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Profile)element).getName();
            }
        });
        column = new TableViewerColumn(this.profileTableViewer, 16384);
        column.getColumn().setText("Needed Quirks");
        column.getColumn().setWidth(400);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String q = ((Profile)element).getQuirks();
                return q == null ? "" : q;
            }
        });
        this.profileTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.profileTableViewer.setInput(this.viewModel.getProfiles());
        Label tcLabel = new Label(this.toolchainComposite, 0);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        tcLabel.setLayoutData((Object)gridData2);
        tcLabel.setText("Toolchains");
        this.toolchainNamesViewer = new TableViewer(this.toolchainComposite, 67584);
        Table tcNames = this.toolchainNamesViewer.getTable();
        gridData = new GridData(1808);
        gridData.heightHint = 120;
        gridData.widthHint = 300;
        tcNames.setLayoutData((Object)gridData);
        tcNames.setHeaderVisible(false);
        tcNames.setLinesVisible(true);
        this.toolchainVersionsViewer = new TableViewer(this.toolchainComposite, 67584);
        Table tcVersions = this.toolchainVersionsViewer.getTable();
        GridData gridData3 = new GridData(1808);
        gridData3.heightHint = 120;
        gridData3.widthHint = 300;
        tcVersions.setLayoutData((Object)gridData3);
        tcVersions.setHeaderVisible(false);
        tcVersions.setLinesVisible(true);
        this.toolchainNamesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.toolchainNamesViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Toolchain)element).getName();
            }
        });
        this.toolchainNamesViewer.setInput(this.viewModel.getToolchains());
        this.toolchainVersionsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.toolchainVersionsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        Label emLabelTitle = new Label(this.emulatorHeader, 0);
        emLabelTitle.setText("Emulators");
        GridData emLabelGd = new GridData(4, 0x1000000, true, false);
        emLabelTitle.setLayoutData((Object)emLabelGd);
        this.emulatorCheckBox = new Button(this.emulatorHeader, 32);
        this.emulatorCheckBox.setText("Enable");
        this.emulatorCheckBox.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.emulatorNamesViewer = new TableViewer(this.emulatorComposite, 67584);
        this.emulatorNames = this.emulatorNamesViewer.getTable();
        this.emulatorNames.setHeaderVisible(false);
        this.emulatorNames.setLinesVisible(true);
        GridData enData = new GridData(1808);
        enData.heightHint = 80;
        enData.widthHint = 300;
        this.emulatorNames.setLayoutData((Object)enData);
        this.emulatorVersionsViewer = new TableViewer(this.emulatorComposite, 67584);
        this.emulatorVersions = this.emulatorVersionsViewer.getTable();
        this.emulatorVersions.setHeaderVisible(false);
        this.emulatorVersions.setLinesVisible(true);
        GridData evData = new GridData(1808);
        evData.heightHint = 80;
        evData.widthHint = 300;
        this.emulatorVersions.setLayoutData((Object)evData);
        this.emulatorNamesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.emulatorNamesViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Emulator)element).getName();
            }
        });
        this.emulatorNamesViewer.setInput(this.viewModel.getEmulators());
        this.emulatorVersionsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.emulatorVersionsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        this.sysrootDefaultRadio = new Button((Composite)this.sysrootGroup, 16);
        this.sysrootDefaultRadio.setText("With sysroot");
        this.sysrootNoneRadio = new Button((Composite)this.sysrootGroup, 16);
        this.sysrootNoneRadio.setText("Without sysroot");
        this.sysrootForeignRadio = new Button((Composite)this.sysrootGroup, 16);
        this.sysrootForeignRadio.setText("Use sysroot from specified package");
        this.sysrootForeignRadio.setEnabled(false);
    }

    private void registerEvents() {
        this.dbc = new DataBindingContext();
        this.container.addDisposeListener(e -> {
            if (this.dbc != null) {
                this.dbc.dispose();
                this.dbc = null;
            }
        });
        IViewerObservableValue profileSelection = ViewerProperties.singleSelection(Profile.class).observe((Viewer)this.profileTableViewer);
        IObservableValue profileIndexObservable = BeanProperties.value(VenvWizardViewModel.class, (String)"selectedProfileIndex", Integer.class).observe((Object)this.viewModel);
        UpdateValueStrategy profileToIndex = new UpdateValueStrategy();
        profileToIndex.setConverter((IConverter)new Converter<Profile, Integer>(Profile.class, Integer.class){

            public Integer convert(Profile fromObject) {
                if (fromObject == null) {
                    return -1;
                }
                return WizardConfigPage.this.viewModel.getProfiles().indexOf(fromObject);
            }
        });
        UpdateValueStrategy indexToProfile = new UpdateValueStrategy();
        indexToProfile.setConverter((IConverter)new Converter<Integer, Profile>(Integer.class, Profile.class){

            public Profile convert(Integer fromObject) {
                int idx = fromObject;
                return idx >= 0 && idx < WizardConfigPage.this.viewModel.getProfiles().size() ? WizardConfigPage.this.viewModel.getProfiles().get(idx) : null;
            }
        });
        this.dbc.bindValue((IObservableValue)profileSelection, profileIndexObservable, profileToIndex, indexToProfile);
        IViewerObservableValue toolchainSelection = ViewerProperties.singleSelection(Toolchain.class).observe((Viewer)this.toolchainNamesViewer);
        IObservableValue toolchainIndexObservable = BeanProperties.value(VenvWizardViewModel.class, (String)"selectedToolchainIndex", Integer.class).observe((Object)this.viewModel);
        UpdateValueStrategy toolchainToIndex = new UpdateValueStrategy();
        toolchainToIndex.setConverter((IConverter)new Converter<Toolchain, Integer>(Toolchain.class, Integer.class){

            public Integer convert(Toolchain fromObject) {
                if (fromObject == null) {
                    return -1;
                }
                return WizardConfigPage.this.viewModel.getToolchains().indexOf(fromObject);
            }
        });
        UpdateValueStrategy indexToToolchain = new UpdateValueStrategy();
        indexToToolchain.setConverter((IConverter)new Converter<Integer, Toolchain>(Integer.class, Toolchain.class){

            public Toolchain convert(Integer fromObject) {
                int idx = fromObject;
                if (idx >= 0 && idx < WizardConfigPage.this.viewModel.getToolchains().size()) {
                    return WizardConfigPage.this.viewModel.getToolchains().get(idx);
                }
                return null;
            }
        });
        this.dbc.bindValue((IObservableValue)toolchainSelection, toolchainIndexObservable, toolchainToIndex, indexToToolchain);
        toolchainIndexObservable.addValueChangeListener(e -> {
            int idx = this.viewModel.getSelectedToolchainIndex();
            if (idx >= 0 && idx < this.viewModel.getToolchains().size()) {
                this.toolchainVersionsViewer.setInput(this.viewModel.getToolchains().get(idx).getVersions());
            } else {
                this.toolchainVersionsViewer.setInput(List.of());
            }
        });
        IViewerObservableValue toolchainVersionSelection = ViewerProperties.singleSelection(String.class).observe((Viewer)this.toolchainVersionsViewer);
        IObservableValue toolchainVersionIndexObservable = BeanProperties.value(VenvWizardViewModel.class, (String)"selectedToolchainVersionIndex", Integer.class).observe((Object)this.viewModel);
        UpdateValueStrategy toolchainVersionToIndex = new UpdateValueStrategy();
        toolchainVersionToIndex.setConverter((IConverter)new Converter<String, Integer>(String.class, Integer.class){

            public Integer convert(String fromObject) {
                int idx = WizardConfigPage.this.viewModel.getSelectedToolchainIndex();
                if (idx < 0 || idx >= WizardConfigPage.this.viewModel.getToolchains().size()) {
                    return -1;
                }
                List<String> vers = WizardConfigPage.this.viewModel.getToolchains().get(idx).getVersions();
                return vers == null ? -1 : vers.indexOf(fromObject);
            }
        });
        UpdateValueStrategy indexToToolchainVersion = new UpdateValueStrategy();
        indexToToolchainVersion.setConverter((IConverter)new Converter<Integer, String>(Integer.class, String.class){

            public String convert(Integer fromObject) {
                int idx = WizardConfigPage.this.viewModel.getSelectedToolchainIndex();
                if (idx < 0 || idx >= WizardConfigPage.this.viewModel.getToolchains().size()) {
                    return null;
                }
                List<String> vers = WizardConfigPage.this.viewModel.getToolchains().get(idx).getVersions();
                int verIdx = fromObject;
                return vers != null && verIdx >= 0 && verIdx < vers.size() ? vers.get(verIdx) : null;
            }
        });
        this.dbc.bindValue((IObservableValue)toolchainVersionSelection, toolchainVersionIndexObservable, toolchainVersionToIndex, indexToToolchainVersion);
        IObservableValue emulatorEnabledObservable = BeanProperties.value(VenvWizardViewModel.class, (String)"emulatorEnabled", Boolean.class).observe((Object)this.viewModel);
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.emulatorCheckBox), emulatorEnabledObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.emulatorNames), emulatorEnabledObservable);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.emulatorVersions), emulatorEnabledObservable);
        IViewerObservableValue emulatorSelection = ViewerProperties.singleSelection(Emulator.class).observe((Viewer)this.emulatorNamesViewer);
        IObservableValue emulatorIndexObservable = BeanProperties.value(VenvWizardViewModel.class, (String)"selectedEmulatorIndex", Integer.class).observe((Object)this.viewModel);
        UpdateValueStrategy emulatorToIndex = new UpdateValueStrategy();
        emulatorToIndex.setConverter((IConverter)new Converter<Emulator, Integer>(Emulator.class, Integer.class){

            public Integer convert(Emulator fromObject) {
                if (fromObject == null) {
                    return -1;
                }
                return WizardConfigPage.this.viewModel.getEmulators().indexOf(fromObject);
            }
        });
        UpdateValueStrategy indexToEmulator = new UpdateValueStrategy();
        indexToEmulator.setConverter((IConverter)new Converter<Integer, Emulator>(Integer.class, Emulator.class){

            public Emulator convert(Integer fromObject) {
                int idx = fromObject;
                if (idx >= 0 && idx < WizardConfigPage.this.viewModel.getEmulators().size()) {
                    return WizardConfigPage.this.viewModel.getEmulators().get(idx);
                }
                return null;
            }
        });
        this.dbc.bindValue((IObservableValue)emulatorSelection, emulatorIndexObservable, emulatorToIndex, indexToEmulator);
        emulatorIndexObservable.addValueChangeListener(e -> {
            int idx = this.viewModel.getSelectedEmulatorIndex();
            if (idx >= 0 && idx < this.viewModel.getEmulators().size()) {
                this.emulatorVersionsViewer.setInput(this.viewModel.getEmulators().get(idx).getVersions());
            } else {
                this.emulatorVersionsViewer.setInput(List.of());
            }
        });
        IViewerObservableValue emulatorVersionSelection = ViewerProperties.singleSelection(String.class).observe((Viewer)this.emulatorVersionsViewer);
        IObservableValue emulatorVersionIndexObservable = BeanProperties.value(VenvWizardViewModel.class, (String)"selectedEmulatorVersionIndex", Integer.class).observe((Object)this.viewModel);
        UpdateValueStrategy emulatorVersionToIndex = new UpdateValueStrategy();
        emulatorVersionToIndex.setConverter((IConverter)new Converter<String, Integer>(String.class, Integer.class){

            public Integer convert(String fromObject) {
                int idx = WizardConfigPage.this.viewModel.getSelectedEmulatorIndex();
                if (idx < 0 || idx >= WizardConfigPage.this.viewModel.getEmulators().size()) {
                    return -1;
                }
                List<String> vers = WizardConfigPage.this.viewModel.getEmulators().get(idx).getVersions();
                return vers == null ? -1 : vers.indexOf(fromObject);
            }
        });
        UpdateValueStrategy indexToEmulatorVersion = new UpdateValueStrategy();
        indexToEmulatorVersion.setConverter((IConverter)new Converter<Integer, String>(Integer.class, String.class){

            public String convert(Integer fromObject) {
                int idx = WizardConfigPage.this.viewModel.getSelectedEmulatorIndex();
                if (idx < 0 || idx >= WizardConfigPage.this.viewModel.getEmulators().size()) {
                    return null;
                }
                List<String> vers = WizardConfigPage.this.viewModel.getEmulators().get(idx).getVersions();
                int verIdx = fromObject;
                return vers != null && verIdx >= 0 && verIdx < vers.size() ? vers.get(verIdx) : null;
            }
        });
        this.dbc.bindValue((IObservableValue)emulatorVersionSelection, emulatorVersionIndexObservable, emulatorVersionToIndex, indexToEmulatorVersion);
        SelectObservableValue sysrootSelection = new SelectObservableValue();
        sysrootSelection.addOption((Object)VenvWizardViewModel.SysrootOption.DEFAULT_SYSROOT, (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.sysrootDefaultRadio));
        sysrootSelection.addOption((Object)VenvWizardViewModel.SysrootOption.NONE_SYSROOT, (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.sysrootNoneRadio));
        sysrootSelection.addOption((Object)VenvWizardViewModel.SysrootOption.FOREIGN_TOOLCHAIN, (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.sysrootForeignRadio));
        this.dbc.bindValue((IObservableValue)sysrootSelection, BeanProperties.value(VenvWizardViewModel.class, (String)"sysrootOption", VenvWizardViewModel.SysrootOption.class).observe((Object)this.viewModel));
        IObservableValue completeObservable = BeanProperties.value(VenvWizardViewModel.class, (String)"configurationPageComplete", Boolean.class).observe((Object)this.viewModel);
        completeObservable.addValueChangeListener(e -> this.updatePageComplete());
    }

    private void updatePageComplete() {
        this.setPageComplete(this.viewModel.isConfigurationPageComplete());
        if (this.getWizard() != null && this.getWizard().getContainer() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }
}

