/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.venv.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.ruyisdk.ruyi.services.RuyiCli;
import org.ruyisdk.venv.viewmodel.VenvWizardViewModel;
import org.ruyisdk.venv.views.WizardConfigPage;
import org.ruyisdk.venv.views.WizardLocationPage;

public class VenvWizard
extends Wizard {
    private final VenvWizardViewModel viewModel;
    private WizardConfigPage configurationPage;
    private WizardLocationPage locationPage;

    public VenvWizard(VenvWizardViewModel viewModel) {
        this.viewModel = viewModel;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New virtual environment");
    }

    public void addPages() {
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
            if (pmd.getShell() != null) {
                pmd.getShell().setText("Updating package index");
            }
            pmd.run(true, true, monitor -> {
                monitor.beginTask("Updating package index...", 100);
                RuyiCli.RunResult result = this.viewModel.updateIndex();
                if (result == null) {
                    throw new InvocationTargetException(new Exception("Update returned no result"));
                }
                if (result.getExitCode() != 0) {
                    throw new InvocationTargetException(new Exception(result.getOutput()));
                }
                monitor.worked(100);
            });
        }
        catch (InvocationTargetException e) {
            String detail = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            this.displaySelectableError("Package Index Update Failed", "Failed to update package index; wizard will abort.", detail == null ? "" : detail);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.displaySelectableError("Package Index Update Cancelled", "Update was cancelled; wizard will abort.", "");
            return;
        }
        this.configurationPage = new WizardConfigPage(this.viewModel);
        this.addPage((IWizardPage)this.configurationPage);
        this.locationPage = new WizardLocationPage(this.viewModel);
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean canFinish() {
        return this.locationPage != null && this.locationPage.isPageComplete();
    }

    public boolean performFinish() {
        IRunnableWithProgress operation = monitor -> {
            monitor.subTask("install toolchain");
            RuyiCli.RunResult result = this.viewModel.installToolchain();
            if (result.getExitCode() != 0) {
                throw new InvocationTargetException(new Exception("Failed to install toolchain:\n" + result.getOutput()));
            }
            if (this.viewModel.isEmulatorEnabled()) {
                monitor.subTask("install emulator");
                result = this.viewModel.installEmulator();
                if (result.getExitCode() != 0) {
                    throw new InvocationTargetException(new Exception("Failed to install emulator:\n" + result.getOutput()));
                }
            }
            monitor.subTask("create venv");
            result = this.viewModel.createVenv();
            if (result.getExitCode() != 0) {
                String errorMessage = "Failed to create venv, exit=" + result.getExitCode() + "\n" + result.getOutput();
                throw new InvocationTargetException(new Exception(errorMessage));
            }
        };
        try {
            this.getContainer().run(true, true, operation);
            return true;
        }
        catch (InvocationTargetException e) {
            String detail;
            String string = detail = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            if (detail == null) {
                detail = "";
            }
            this.displaySelectableError("Virtual Environment Setup Failed", "Unable to complete virtual environment setup \u2014 see details below.", detail);
            return false;
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Cancelled", (String)"Operation was cancelled");
            return false;
        }
    }

    private void displaySelectableError(final String title, final String message, final String details) {
        Dialog dialog = new Dialog(this.getShell()){

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                composite.setLayout((Layout)new GridLayout(1, false));
                Text msgText = new Text(composite, 2632);
                GridData gridData = new GridData(768);
                gridData.heightHint = 80;
                msgText.setLayoutData((Object)gridData);
                msgText.setText(message == null ? "" : message);
                Label detailsLabel = new Label(composite, 0);
                detailsLabel.setText("Details:");
                Text detailsText = new Text(composite, 2826);
                detailsText.setLayoutData((Object)new GridData(1808));
                detailsText.setText(details == null ? "" : details);
                return composite;
            }

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(title == null ? "Error" : title);
            }

            protected boolean isResizable() {
                return true;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            }
        };
        dialog.open();
    }
}

