/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.devices.views;

import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.ruyisdk.devices.Activator;
import org.ruyisdk.devices.model.Device;
import org.ruyisdk.devices.providers.DeviceLabelProvider;
import org.ruyisdk.devices.services.DeviceService;
import org.ruyisdk.devices.views.DeviceDialog;

public class DevicePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer tableViewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button setDefaultButton;
    private Label infoLabel;
    private DeviceService deviceService = new DeviceService();
    private List<Device> devices;

    public DevicePreferencePage() {
        if (Activator.getDefault() == null) {
            throw new IllegalStateException("Plugin not activated!");
        }
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        this.noDefaultButton();
    }

    protected Control createContents(Composite parent) {
        String[] columnNames;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.infoLabel = new Label(container, 0);
        this.infoLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Composite tableComposite = new Composite(container, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(tableComposite, 67584);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] stringArray = columnNames = new String[]{"Name", "SOC", "Vendor", "Version", "Default"};
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnName);
            column.setWidth(120);
            ++n2;
        }
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DeviceLabelProvider());
        Composite buttonComposite = new Composite(container, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.addButton = this.createButton(buttonComposite, "Add");
        this.editButton = this.createButton(buttonComposite, "Edit");
        this.removeButton = this.createButton(buttonComposite, "Remove");
        this.setDefaultButton = this.createButton(buttonComposite, "Set Default");
        this.refreshView();
        this.bindButtonEvents();
        return container;
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return button;
    }

    private void refreshView() {
        this.devices = this.deviceService.getDevices();
        this.tableViewer.setInput(this.devices);
        boolean hasBoards = !this.devices.isEmpty();
        boolean hasDefault = this.devices.stream().anyMatch(Device::isDefault);
        this.editButton.setEnabled(hasBoards);
        this.removeButton.setEnabled(hasBoards);
        this.setDefaultButton.setEnabled(hasBoards);
        if (this.devices.isEmpty()) {
            this.infoLabel.setText("\u60a8\u8fd8\u672a\u6dfb\u52a0\u4efb\u4f55RISC-V\u5f00\u53d1\u677f\u3002");
        } else if (!hasDefault) {
            this.infoLabel.setText("\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u5f00\u53d1\u677f\u4ee5\u83b7\u53d6IDE\u8d44\u6e90\u63a8\u8350\u3002");
        } else {
            this.infoLabel.setText("\u5f53\u524d\u7ba1\u7406\u7684\u5f00\u53d1\u677f\u5217\u8868\uff1a");
        }
    }

    private void refreshTable() {
        this.tableViewer.setInput(this.deviceService.getDevices());
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    private void bindButtonEvents() {
        this.addButton.addListener(13, e -> this.handleAddDevice());
        this.editButton.addListener(13, e -> this.handleEditDevice());
        this.removeButton.addListener(13, e -> this.handleRemoveDevice());
        this.setDefaultButton.addListener(13, e -> this.handleSetDefault());
    }

    private void handleAddDevice() {
        DeviceDialog dialog = new DeviceDialog(this.getShell(), null);
        if (dialog.open() == 0) {
            this.deviceService.addDevice(dialog.getDevice());
            this.refreshView();
        }
    }

    private void handleEditDevice() {
        DeviceDialog dialog;
        Device selectedDevice = this.getSelectedDevice();
        if (selectedDevice != null && (dialog = new DeviceDialog(this.getShell(), selectedDevice)).open() == 0) {
            this.deviceService.updateDevice(selectedDevice, dialog.getDevice());
            this.refreshView();
        }
    }

    private void handleRemoveDevice() {
        Device selectedDevice = this.getSelectedDevice();
        if (selectedDevice != null) {
            this.deviceService.deleteDevice(selectedDevice);
            this.refreshTable();
            this.refreshView();
        }
    }

    private void handleSetDefault() {
        Device selectedDevice = this.getSelectedDevice();
        if (selectedDevice != null) {
            this.deviceService.setDefaultDevice(selectedDevice);
            this.refreshTable();
            this.refreshView();
        }
    }

    private Device getSelectedDevice() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        return (Device)selection.getFirstElement();
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        try {
            this.deviceService.saveDevices();
            return true;
        }
        catch (Exception e) {
            this.setErrorMessage("\u4fdd\u5b58\u5931\u8d25: " + e.getMessage());
            return false;
        }
    }
}

