/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.packages;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.ruyisdk.packages.JsonParser;
import org.ruyisdk.packages.TreeContentProvider;
import org.ruyisdk.packages.TreeLabelProvider;
import org.ruyisdk.packages.TreeNode;
import org.ruyisdk.ruyi.util.RuyiFileUtils;

public class PackageExplorerView
extends ViewPart {
    private CheckboxTreeViewer viewer;
    private Process bashProcess;
    private BufferedWriter bashWriter;
    private BufferedReader bashReader;
    private String chosenType;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.chosenType = this.showHardwareTypeSelectionDialog(parent.getShell());
        if (this.chosenType != null) {
            this.refreshList();
        }
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(5, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button refreshButton = new Button(buttonComposite, 8);
        refreshButton.setText("Refresh List");
        refreshButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        refreshButton.addListener(13, event -> this.refreshList());
        Button openDirButton = new Button(buttonComposite, 8);
        openDirButton.setText("Open Pkg Dir");
        openDirButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        openDirButton.addListener(13, event -> {
            try {
                String cacheHome = System.getenv("XDG_CACHE_HOME");
                String downloadDir = cacheHome != null && !cacheHome.isEmpty() ? cacheHome + "/ruyi/distfiles" : System.getProperty("user.home") + "/.cache/ruyi/distfiles";
                Runtime.getRuntime().exec(new String[]{"xdg-open", downloadDir});
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Cannot open compressed package download directory: " + e.getMessage()));
            }
        });
        Button openBlobsButton = new Button(buttonComposite, 8);
        openBlobsButton.setText("Open Images Dir");
        openBlobsButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        openBlobsButton.addListener(13, event -> {
            try {
                String dataHome = System.getenv("XDG_DATA_HOME");
                String blobsDir = dataHome != null && !dataHome.isEmpty() ? dataHome + "/ruyi/blobs" : System.getProperty("user.home") + "/.local/share/ruyi/blobs";
                Runtime.getRuntime().exec(new String[]{"xdg-open", blobsDir});
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Cannot open image files download directory: " + e.getMessage()));
            }
        });
        Button downloadButton = new Button(buttonComposite, 8);
        downloadButton.setText("Download");
        downloadButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        downloadButton.addListener(13, event -> {
            Object[] checkedElements = this.viewer.getCheckedElements();
            ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode node;
                Object obj = objectArray[n2];
                if (obj instanceof TreeNode && (node = (TreeNode)obj).isLeaf() && !node.isDownloaded()) {
                    selectedNodes.add(node);
                }
                ++n2;
            }
            if (selectedNodes.isEmpty()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Point:", (String)"No files selected!");
                return;
            }
            boolean confirmed = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm Download", (String)"Are you sure you want to download the selected files?");
            if (confirmed) {
                for (TreeNode node : selectedNodes) {
                    this.executeInstallCommand(node.getInstallCommand());
                }
            }
        });
        Button switchBoardButton = new Button(buttonComposite, 8);
        switchBoardButton.setText("Select Development Board");
        switchBoardButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        switchBoardButton.addListener(13, event -> {
            String newType = this.showHardwareTypeSelectionDialog(parent.getShell());
            if (newType != null && !newType.equals(this.chosenType)) {
                this.chosenType = newType;
                this.refreshList();
            }
        });
        this.viewer = new CheckboxTreeViewer(parent, 2816);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return false;
            }

            public boolean isGrayed(Object element) {
                if (element instanceof TreeNode) {
                    return !((TreeNode)element).isLeaf();
                }
                return false;
            }
        });
        this.viewer.addCheckStateListener(event -> {
            Object element = event.getElement();
            if (element instanceof TreeNode && !((TreeNode)element).isLeaf()) {
                this.viewer.setChecked(element, false);
            }
        });
        this.createContextMenu();
        this.startBashSession();
        Display.getDefault().asyncExec(() -> {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.showView("org.eclipse.ui.console.ConsoleView");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PackageExplorerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        TreeNode node;
        ITreeSelection selection = this.viewer.getStructuredSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof TreeNode && (node = (TreeNode)firstElement).isLeaf() && node.isDownloaded()) {
            Action uninstallAction = new Action("Uninstall"){

                public void run() {
                    boolean confirmed = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm Uninstall", (String)("Are you sure you want to uninstall the selected package '" + node.getName() + "'?"));
                    if (confirmed) {
                        String ruyiPath = RuyiFileUtils.getInstallPath() + "/ruyi";
                        String installCommand = node.getInstallCommand();
                        String packageName = installCommand.substring(installCommand.lastIndexOf(" ") + 1);
                        String uninstallCommand = ruyiPath + " uninstall " + packageName + " -y";
                        System.err.println("Executing uninstall command: " + uninstallCommand);
                        PackageExplorerView.this.executeInstallCommand(uninstallCommand);
                    }
                }
            };
            manager.add((IAction)uninstallAction);
        }
    }

    private Set<String> getDownloadedFiles() {
        HashSet<String> files = new HashSet<String>();
        String cacheHome = System.getenv("XDG_CACHE_HOME");
        String distfilesDir = cacheHome != null && !cacheHome.isEmpty() ? cacheHome + "/ruyi/distfiles" : System.getProperty("user.home") + "/.cache/ruyi/distfiles";
        this.addFilesFromDir(files, distfilesDir);
        String dataHome = System.getenv("XDG_DATA_HOME");
        String blobsDir = dataHome != null && !dataHome.isEmpty() ? dataHome + "/ruyi/blobs" : System.getProperty("user.home") + "/.local/share/ruyi/blobs";
        this.addFilesFromDir(files, blobsDir);
        return files;
    }

    private void addFilesFromDir(Set<String> files, String dirPath) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(dirPath, new String[0]));){
                for (Path entry : stream) {
                    files.add(entry.getFileName().toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.closeBashSession();
        super.dispose();
    }

    private void startBashSession() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-i");
            processBuilder.redirectErrorStream(true);
            this.bashProcess = processBuilder.start();
            this.bashWriter = new BufferedWriter(new OutputStreamWriter(this.bashProcess.getOutputStream()));
            this.bashReader = new BufferedReader(new InputStreamReader(this.bashProcess.getInputStream()));
            this.bashWriter.write("export RUYI_EXPERIMENTAL=true\n");
            this.bashWriter.flush();
            new Thread(() -> {
                try {
                    while (this.bashReader.readLine() != null) {
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).start();
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Cannot start Bash session: " + e.getMessage()));
        }
    }

    private void closeBashSession() {
        try {
            if (this.bashWriter != null) {
                this.bashWriter.write("exit\n");
                this.bashWriter.flush();
                this.bashWriter.close();
            }
            if (this.bashReader != null) {
                this.bashReader.close();
            }
            if (this.bashProcess != null) {
                this.bashProcess.destroy();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void executeCommandInBackground(String command) {
        new Thread(() -> {
            try {
                String line;
                ArrayList<String> cmdList = new ArrayList<String>();
                cmdList.add("bash");
                cmdList.add("-c");
                cmdList.add(command);
                ProcessBuilder pb = new ProcessBuilder(cmdList);
                pb.environment().put("RUYI_EXPERIMENTAL", "true");
                pb.redirectErrorStream(true);
                Process process = pb.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuilder outputBuilder = new StringBuilder();
                outputBuilder.append("[");
                boolean first = true;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("RUYI_DONE")) break;
                    if ((line = line.trim()).isEmpty() || !line.startsWith("{") || line.contains("\"ty\":\"log-v1\"")) continue;
                    if (!first) {
                        outputBuilder.append(",");
                    }
                    outputBuilder.append(line);
                    first = false;
                }
                outputBuilder.append("]");
                String jsonData = outputBuilder.toString();
                process.waitFor();
                reader.close();
                Display.getDefault().asyncExec(() -> {
                    try {
                        TreeNode root = JsonParser.parseJson(jsonData, this.getDownloadedFiles(), this.chosenType);
                        this.viewer.setInput((Object)root);
                        this.viewer.expandAll();
                        this.markDownloadedNodes(root);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Failed to parse JSON data: " + e.getMessage()));
                    }
                });
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Failed to execute command: " + e.getMessage())));
            }
        }).start();
    }

    private void markDownloadedNodes(TreeNode node) {
        if (node.isLeaf() && node.isDownloaded()) {
            this.viewer.setChecked((Object)node, true);
            this.viewer.setGrayed((Object)node, true);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.markDownloadedNodes(child);
            }
        }
    }

    private void executeInstallCommand(String installCommand) {
        Display.getDefault().asyncExec(() -> {
            OutputLiveDialog dialog = new OutputLiveDialog(Display.getDefault().getActiveShell(), installCommand);
            dialog.open();
        });
    }

    private void refreshList() {
        if (this.chosenType == null || this.chosenType.isEmpty()) {
            return;
        }
        String ruyiPath = RuyiFileUtils.getInstallPath() + "/ruyi";
        String command = ruyiPath + " --porcelain list --related-to-entity device:" + this.chosenType + " ; echo RUYI_DONE";
        this.executeCommandInBackground(command);
    }

    private String[] fetchHardwareEntities() {
        List<Object> entityIds = new ArrayList();
        String ruyiPath = RuyiFileUtils.getInstallPath() + "/ruyi";
        String command = "RUYI_EXPERIMENTAL=x " + ruyiPath + " --porcelain entity list -t device";
        try {
            ProcessBuilder pb = new ProcessBuilder("bash", "-c", command);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                StringBuilder outputBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    outputBuilder.append(line.trim());
                }
                process.waitFor();
                entityIds = JsonParser.parseAllEntityIdsInOneLine(outputBuilder.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entityIds.toArray(new String[0]);
    }

    private String showHardwareTypeSelectionDialog(Shell shell) {
        String[] hardwareTypes = this.fetchHardwareEntities();
        if (hardwareTypes == null || hardwareTypes.length == 0) {
            String msg = "Could not find any supported development board entities. Please check your Ruyi installation.";
            MessageDialog.openWarning((Shell)shell, (String)"No Hardware Found", (String)msg);
            return null;
        }
        HardwareSelectionDialog dialog = new HardwareSelectionDialog(shell, hardwareTypes);
        if (dialog.open() == 0) {
            return dialog.getSelectedHardwareType();
        }
        return null;
    }

    class HardwareSelectionDialog
    extends Dialog {
        private org.eclipse.swt.widgets.List listWidget;
        private String[] hardwareTypes;
        private String selectedHardwareType;
        private String title;

        public HardwareSelectionDialog(Shell parentShell, String[] hardwareTypes) {
            super(parentShell);
            this.hardwareTypes = hardwareTypes;
            this.title = "Select Development Board";
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout(1, false));
            this.listWidget = new org.eclipse.swt.widgets.List(container, 2564);
            GridData gd = new GridData(1808);
            this.listWidget.setLayoutData((Object)gd);
            if (this.hardwareTypes != null) {
                this.listWidget.setItems(this.hardwareTypes);
            }
            this.listWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    HardwareSelectionDialog.this.okPressed();
                }
            });
            return container;
        }

        protected void okPressed() {
            String[] selection = this.listWidget.getSelection();
            if (selection.length > 0) {
                this.selectedHardwareType = selection[0];
            }
            super.okPressed();
        }

        public String getSelectedHardwareType() {
            return this.selectedHardwareType;
        }

        protected Point getInitialSize() {
            return new Point(450, 300);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Select", true);
            this.createButton(parent, 1, "Cancel", false);
        }
    }

    class OutputDialog
    extends Dialog {
        private String content;

        public OutputDialog(Shell parentShell, String content) {
            super(parentShell);
            this.content = content;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout(1, false));
            Text text = new Text(container, 2826);
            text.setLayoutData((Object)new GridData(4, 4, true, true));
            text.setText(this.content);
            return container;
        }

        protected Point getInitialSize() {
            return new Point(600, 400);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "OK", true);
        }
    }

    class OutputLiveDialog
    extends Dialog {
        private String installCommand;
        private Text text;

        public OutputLiveDialog(Shell parentShell, String installCommand) {
            super(parentShell);
            this.installCommand = installCommand;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout(1, false));
            this.text = new Text(container, 2890);
            this.text.setLayoutData((Object)new GridData(4, 4, true, true));
            this.text.setText("Executing command:\n" + this.installCommand + "\n\nOutput:\n");
            this.startCommand();
            return container;
        }

        private void startCommand() {
            new Thread(() -> {
                try {
                    String line;
                    ArrayList<String> cmdList = new ArrayList<String>();
                    cmdList.add("bash");
                    cmdList.add("-c");
                    cmdList.add(this.installCommand + " && echo RUYI_DONE");
                    ProcessBuilder pb = new ProcessBuilder(cmdList);
                    pb.redirectErrorStream(true);
                    String home = System.getProperty("user.home");
                    pb.environment().put("HOME", home);
                    String xdgCacheHome = System.getenv("XDG_CACHE_HOME");
                    if (xdgCacheHome != null && !xdgCacheHome.isEmpty()) {
                        pb.environment().put("XDG_CACHE_HOME", xdgCacheHome);
                    }
                    Process process = pb.start();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                        String outputLine = line + "\n";
                        Display.getDefault().asyncExec(() -> {
                            if (this.text != null && !this.text.isDisposed()) {
                                this.text.append(outputLine);
                            }
                        });
                        if (!line.contains("RUYI_DONE")) continue;
                        Display.getDefault().asyncExec(() -> PackageExplorerView.this.refreshList());
                        break;
                    }
                    reader.close();
                    process.waitFor();
                }
                catch (IOException | InterruptedException e) {
                    Display.getDefault().asyncExec(() -> {
                        if (this.text != null && !this.text.isDisposed()) {
                            this.text.append("Failed to execute the installation command: " + e.getMessage() + "\n");
                        }
                    });
                }
            }).start();
        }

        protected Point getInitialSize() {
            return new Point(600, 400);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "OK", true);
        }
    }
}

