/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.packages;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.ruyisdk.packages.TreeNode;
import org.ruyisdk.ruyi.util.RuyiFileUtils;

public class JsonParser {
    public static TreeNode parseJson(String jsonData, Set<String> downloadedFiles, String hardwareType) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JsonReader reader = Json.createReader((Reader)new StringReader(jsonData));){
                JsonStructure jsonStructure = reader.read();
                TreeNode root = new TreeNode(hardwareType, null);
                if (jsonStructure instanceof JsonObject) {
                    JsonParser.parseJsonObject((JsonObject)jsonStructure, root, downloadedFiles);
                } else if (jsonStructure instanceof JsonArray) {
                    JsonArray jsonArray = (JsonArray)jsonStructure;
                    for (JsonValue value : jsonArray) {
                        if (!(value instanceof JsonObject)) continue;
                        JsonParser.parseJsonObject((JsonObject)value, root, downloadedFiles);
                    }
                }
                return root;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JSON data:" + e.getMessage(), e);
        }
    }

    private static void parseJsonObject(JsonObject rootObject, TreeNode root, Set<String> downloadedFiles) {
        if (!rootObject.containsKey((Object)"category") || !rootObject.containsKey((Object)"name")) {
            return;
        }
        String category = rootObject.getString("category");
        TreeNode categoryNode = JsonParser.findOrCreateCategoryNode(root, category);
        String name = rootObject.getString("name");
        TreeNode packageNode = new TreeNode(name, null);
        categoryNode.addChild(packageNode);
        JsonArray versions = rootObject.getJsonArray("vers");
        if (versions != null) {
            for (JsonValue versionValue : versions) {
                JsonObject versionObject = versionValue.asJsonObject();
                if (!versionObject.containsKey((Object)"semver")) continue;
                String semver = versionObject.getString("semver");
                JsonArray remarks = versionObject.getJsonArray("remarks");
                String remark = remarks != null && !remarks.isEmpty() ? " [" + remarks.getString(0) + "]" : "";
                boolean isDownloaded = versionObject.getBoolean("is_installed", false);
                String installCommand = RuyiFileUtils.getInstallPath() + "/ruyi install '" + name + "(" + semver + ")'";
                TreeNode versionNode = new TreeNode(semver + remark, null, installCommand);
                versionNode.setLeaf(true);
                versionNode.setDownloaded(isDownloaded);
                packageNode.addChild(versionNode);
            }
        }
    }

    private static TreeNode findOrCreateCategoryNode(TreeNode root, String category) {
        for (TreeNode child : root.getChildren()) {
            if (!child.getName().equals(category)) continue;
            return child;
        }
        TreeNode categoryNode = new TreeNode(category, null);
        root.addChild(categoryNode);
        return categoryNode;
    }

    public static List<String> parseAllEntityIdsInOneLine(String jsonLine) {
        ArrayList<String> entityIds = new ArrayList<String>();
        int bracketCount = 0;
        int start = -1;
        int i = 0;
        while (i < jsonLine.length()) {
            char c = jsonLine.charAt(i);
            if (c == '{') {
                if (bracketCount == 0) {
                    start = i;
                }
                ++bracketCount;
            } else if (c == '}' && --bracketCount == 0 && start != -1) {
                String singleObject = jsonLine.substring(start, i + 1);
                JsonParser.parseSingleObject(singleObject, entityIds);
                start = -1;
            }
            ++i;
        }
        return entityIds;
    }

    private static void parseSingleObject(String jsonStr, List<String> entityIds) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (JsonReader reader = Json.createReader((Reader)new StringReader(jsonStr));){
                JsonStructure value = reader.read();
                JsonParser.collectEntityIds((JsonValue)value, entityIds);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            System.err.println("\u65e0\u6cd5\u89e3\u6790\u7684 JSON \u5bf9\u8c61: " + jsonStr);
        }
    }

    private static void collectEntityIds(JsonValue value, List<String> entityIds) {
        switch (value.getValueType()) {
            case OBJECT: {
                JsonObject obj = value.asJsonObject();
                if (obj.containsKey((Object)"entity_id")) {
                    entityIds.add(obj.getString("entity_id"));
                }
                for (String key : obj.keySet()) {
                    JsonParser.collectEntityIds((JsonValue)obj.get((Object)key), entityIds);
                }
                break;
            }
            case ARRAY: {
                JsonArray arr = value.asJsonArray();
                for (JsonValue v : arr) {
                    JsonParser.collectEntityIds(v, entityIds);
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String findInstalledToolchainForBoard(String boardName) {
        block32: {
            if (boardName == null || boardName.trim().isEmpty()) {
                return null;
            }
            ruyiPath = RuyiFileUtils.getInstallPath() + "/ruyi";
            entity = boardName.startsWith("device:") != false ? boardName : "device:" + boardName;
            command = ruyiPath + " --porcelain list --related-to-entity " + (String)entity;
            pb = new ProcessBuilder(new String[]{"bash", "-c", command});
            pb.environment().put("RUYI_EXPERIMENTAL", "true");
            pb.redirectErrorStream(true);
            process = pb.start();
            jsonStream = new StringBuilder();
            var7_8 = null;
            var8_10 = null;
            try {
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    while ((line = reader.readLine()) != null) {
                        jsonStream.append(line);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Throwable var8_11) {
                if (var7_8 == null) {
                    var7_8 = var8_11;
                } else if (var7_8 != var8_11) {
                    var7_8.addSuppressed(var8_11);
                }
                throw var7_8;
            }
            process.waitFor();
            rawJson = jsonStream.toString();
            if (!rawJson.trim().isEmpty()) break block32;
            return null;
        }
        try {
            jsonData = "[" + rawJson.replace("}{", "},{") + "]";
            var9_12 = null;
            var10_14 = null;
            try {
                reader = Json.createReader((Reader)new StringReader(jsonData));
                try {
                    jsonArray = reader.readArray();
                    var14_18 = jsonArray.iterator();
                    while (true) {
                        value = (JsonValue)var14_18.next();
                        if (value.getValueType() != JsonValue.ValueType.OBJECT) {
                        }
                        pkgObject = (JsonObject)value;
                        category = pkgObject.getString("category", "");
                        if ("toolchain".equals(category)) {
                            versions = pkgObject.getJsonArray("vers");
                            if (versions == null) {
                            }
                            for (JsonValue verValue : versions) {
                                verObject = (JsonObject)verValue;
                                if (!verObject.getBoolean("is_installed", false)) continue;
                                if (verObject.containsKey((Object)"install_command") && (lastSpace = (installCommand = verObject.getString("install_command")).lastIndexOf(32)) != -1) {
                                    return installCommand.substring(lastSpace + 1);
                                }
                                pkgName = pkgObject.getString("name");
                                pkgVersion = verObject.getString("semver");
                                return pkgName + "-" + pkgVersion;
                            }
                        }
                        break;
                    }
                }
                finally {
                    if (var14_18.hasNext()) ** continue;
                }
            }
            catch (Throwable var10_15) {
                if (var9_12 == null) {
                    var9_12 = var10_15;
                } else if (var9_12 != var10_15) {
                    var9_12.addSuppressed(var10_15);
                }
                throw var9_12;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }
}

