/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;

public class RuyiNetworkUtils {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final int READ_TIMEOUT = 30000;
    private static final int BUFFER_SIZE = 8192;

    public static void downloadFile(String fileUrl, String destinationPath, IProgressMonitor monitor, BiConsumer<Long, Long> progressCallback) throws IOException {
        HttpURLConnection connection = null;
        InputStream input = null;
        BufferedOutputStream output = null;
        try {
            int bytesRead;
            URL url = new URL(fileUrl);
            System.out.println("fileUrl===" + fileUrl);
            connection = (HttpURLConnection)url.openConnection();
            RuyiNetworkUtils.configureConnection(connection);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("Server returned HTTP " + responseCode + ": " + connection.getResponseMessage());
            }
            long fileSize = connection.getContentLengthLong();
            input = connection.getInputStream();
            output = new BufferedOutputStream(new FileOutputStream(destinationPath));
            byte[] buffer = new byte[8192];
            long totalRead = 0L;
            while ((bytesRead = input.read(buffer)) != -1 && !monitor.isCanceled()) {
                ((OutputStream)output).write(buffer, 0, bytesRead);
                totalRead += (long)bytesRead;
                if (fileSize <= 0L || progressCallback == null) continue;
                progressCallback.accept(totalRead, fileSize);
            }
            if (monitor.isCanceled()) {
                throw new InterruptedIOException("Download cancelled by user");
            }
        }
        catch (Throwable throwable) {
            RuyiNetworkUtils.closeQuietly(input);
            RuyiNetworkUtils.closeQuietly(output);
            if (connection != null) {
                connection.disconnect();
            }
            throw throwable;
        }
        RuyiNetworkUtils.closeQuietly(input);
        RuyiNetworkUtils.closeQuietly(output);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public static String fetchStringContent(String urlString, IProgressMonitor monitor) throws IOException {
        String string;
        HttpURLConnection connection = null;
        InputStream input = null;
        try {
            String line;
            int responseCode;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            RuyiNetworkUtils.configureConnection(connection);
            if (monitor != null) {
                monitor.subTask("Connecting to " + url.getHost());
            }
            if ((responseCode = connection.getResponseCode()) != 200) {
                throw new IOException("HTTP request failed with code: " + responseCode);
            }
            input = connection.getInputStream();
            StringBuilder content = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            while (!((line = reader.readLine()) == null || monitor != null && monitor.isCanceled())) {
                content.append(line).append("\n");
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (monitor != null && monitor.isCanceled()) {
                throw new InterruptedIOException("Operation cancelled by user");
            }
            string = content.toString();
        }
        catch (Throwable throwable) {
            RuyiNetworkUtils.closeQuietly(input);
            if (connection != null) {
                connection.disconnect();
            }
            throw throwable;
        }
        RuyiNetworkUtils.closeQuietly(input);
        if (connection != null) {
            connection.disconnect();
        }
        return string;
    }

    public static String postJson(String urlString, Map<String, Object> data, IProgressMonitor monitor) throws IOException {
        String string;
        HttpURLConnection connection = null;
        OutputStream output = null;
        InputStream input = null;
        try {
            String line;
            int responseCode;
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            RuyiNetworkUtils.configureConnection(connection);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; utf-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            if (monitor != null) {
                monitor.subTask("Preparing request data");
            }
            String jsonInput = JsonUtils.toJson(data);
            byte[] inputBytes = jsonInput.getBytes(StandardCharsets.UTF_8);
            connection.setFixedLengthStreamingMode(inputBytes.length);
            output = connection.getOutputStream();
            output.write(inputBytes);
            output.flush();
            if (monitor != null) {
                monitor.worked(30);
                monitor.subTask("Waiting for server response");
            }
            if ((responseCode = connection.getResponseCode()) != 200) {
                throw new IOException("HTTP request failed with code: " + responseCode);
            }
            input = connection.getInputStream();
            StringBuilder response = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            while (!((line = reader.readLine()) == null || monitor != null && monitor.isCanceled())) {
                response.append(line);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (monitor != null && monitor.isCanceled()) {
                throw new InterruptedIOException("Operation cancelled by user");
            }
            string = response.toString();
        }
        catch (Throwable throwable) {
            RuyiNetworkUtils.closeQuietly(output);
            RuyiNetworkUtils.closeQuietly(input);
            if (connection != null) {
                connection.disconnect();
            }
            throw throwable;
        }
        RuyiNetworkUtils.closeQuietly(output);
        RuyiNetworkUtils.closeQuietly(input);
        if (connection != null) {
            connection.disconnect();
        }
        return string;
    }

    public static boolean isUrlAccessible(String urlString, int timeoutMillis) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(timeoutMillis);
            connection.setReadTimeout(timeoutMillis);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            boolean bl = 200 <= responseCode && responseCode <= 399;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static void configureConnection(HttpURLConnection connection) {
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(30000);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("User-Agent", "RuyiSDK-EclipsePlugin");
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class JsonUtils {
        private JsonUtils() {
        }

        static String toJson(Map<String, Object> data) {
            StringBuilder json = new StringBuilder("{");
            boolean first = true;
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if (!first) {
                    json.append(",");
                }
                first = false;
                json.append("\"").append(JsonUtils.escapeJson(entry.getKey())).append("\":");
                Object value = entry.getValue();
                if (value instanceof String) {
                    json.append("\"").append(JsonUtils.escapeJson((String)value)).append("\"");
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    json.append(value);
                    continue;
                }
                json.append("\"").append(JsonUtils.escapeJson(value.toString())).append("\"");
            }
            json.append("}");
            return json.toString();
        }

        private static String escapeJson(String str) {
            return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
        }
    }
}

