/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.ruyisdk.core.config.Constants;
import org.ruyisdk.ruyi.services.RuyiProperties;

public class RuyiFileUtils {
    public static Path getDefaultInstallPath() {
        Path path;
        String ruyiDefaultInstallDir = Constants.Ruyi.INSTALL_PATH.trim();
        if (ruyiDefaultInstallDir.startsWith("~")) {
            ruyiDefaultInstallDir = ruyiDefaultInstallDir.replaceFirst("^~", System.getProperty("user.home"));
        }
        if (!(path = Paths.get(ruyiDefaultInstallDir, new String[0])).isAbsolute()) {
            path = path.toAbsolutePath().normalize();
        }
        return path;
    }

    public static String getInstallPath() {
        String path = RuyiProperties.getInstallPath();
        if (path == null || path.trim().isEmpty()) {
            path = RuyiFileUtils.getDefaultInstallPath().toString();
        }
        return path;
    }

    public static boolean ensureDirectoryExists(String path) throws IOException {
        Path dirPath = Paths.get(path, new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            Files.createDirectories(dirPath, new FileAttribute[0]);
            return true;
        }
        return Files.isDirectory(dirPath, new LinkOption[0]);
    }

    public static boolean isExecutable(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        return Files.exists(path, new LinkOption[0]) && Files.isExecutable(path);
    }

    public static String readFileContent(String filePath) throws IOException {
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    public static void writeFileContent(String filePath, String content) throws IOException {
        Files.write(Paths.get(filePath, new String[0]), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static boolean deleteRecursively(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.list(path).forEach(p -> {
                try {
                    RuyiFileUtils.deleteRecursively(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return Files.deleteIfExists(path);
    }
}

