/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class PathUtils {
    public static boolean isPathConfigured(String path) {
        String normalizedPath = PathUtils.normalizePath(path);
        String currentPath = System.getenv("PATH");
        if (currentPath == null || currentPath.isEmpty()) {
            return false;
        }
        return Arrays.stream(currentPath.split(":")).map(PathUtils::normalizePath).anyMatch(p -> p.equals(normalizedPath));
    }

    private static String normalizePath(String rawPath) {
        try {
            Path path = Paths.get(rawPath, new String[0]).toAbsolutePath().normalize();
            return path.toString().replaceAll("/+$", "");
        }
        catch (Exception exception) {
            return rawPath.replaceAll("/+$", "");
        }
    }

    public static Path detectShellConfigFile() throws IOException {
        String[] candidates;
        String userHome = System.getProperty("user.home");
        String[] stringArray = candidates = new String[]{".bashrc", ".zshrc", ".bash_profile", ".profile"};
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            Path configFile = Paths.get(userHome, filename);
            if (Files.isRegularFile(configFile, new LinkOption[0])) {
                return configFile;
            }
            ++n2;
        }
        return Paths.get(userHome, ".bashrc");
    }
}

