/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.ruyisdk.core.ruyi.model.RuyiReleaseInfo;
import org.ruyisdk.core.ruyi.model.RuyiVersion;
import org.ruyisdk.core.ruyi.model.SystemInfo;
import org.ruyisdk.ruyi.services.RuyiApi;
import org.ruyisdk.ruyi.util.RuyiFileUtils;

public class RuyiManager {
    public static boolean isRuyiInstalled() {
        try {
            Process process = new ProcessBuilder(RuyiFileUtils.getInstallPath() + "/ruyi", "-V").start();
            return process.waitFor() == 0;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RuyiVersion getInstalledVersion() {
        try {
            Process process = new ProcessBuilder(RuyiFileUtils.getInstallPath() + "/ruyi", "-V").start();
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String firstLine = reader.readLine();
                if (firstLine == null) {
                    return null;
                }
                String prefix = "Ruyi ";
                if (!firstLine.startsWith(prefix)) return null;
                String versionStr = firstLine.substring(prefix.length()).trim();
                if (!versionStr.matches("^\\d+\\.\\d+\\.\\d+$")) return null;
                return RuyiVersion.parse((String)versionStr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static RuyiVersion getLatestVersion() {
        String archSuffix = SystemInfo.detectArchitecture().getSuffix();
        RuyiVersion version = null;
        try {
            RuyiReleaseInfo info = RuyiApi.getLatestRelease(archSuffix);
            version = info.getVersion();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return version;
    }
}

