/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.services;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Scanner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.ruyisdk.core.ruyi.model.RepoConfig;
import org.ruyisdk.core.ruyi.model.RuyiReleaseInfo;
import org.ruyisdk.core.ruyi.model.RuyiVersion;
import org.ruyisdk.core.ruyi.model.SystemInfo;
import org.ruyisdk.ruyi.services.RuyiApi;
import org.ruyisdk.ruyi.services.RuyiCommand;
import org.ruyisdk.ruyi.services.RuyiProperties;
import org.ruyisdk.ruyi.ui.RuyiInstallWizard;
import org.ruyisdk.ruyi.util.PathUtils;
import org.ruyisdk.ruyi.util.RuyiFileUtils;
import org.ruyisdk.ruyi.util.RuyiLogger;
import org.ruyisdk.ruyi.util.RuyiNetworkUtils;

public class RuyiInstallManager {
    private final RuyiLogger logger;
    private static final Path DEFAULT_INSTALL_PATH = RuyiFileUtils.getDefaultInstallPath();
    private String installPath;
    private RuyiReleaseInfo latestRelease;
    private RepoConfig[] repoUrls;
    private RuyiProperties.TelemetryStatus telemetryStatus;

    public RuyiInstallManager(RuyiLogger logger) {
        this.logger = logger;
        this.installPath = DEFAULT_INSTALL_PATH.toString();
        this.telemetryStatus = RuyiProperties.TelemetryStatus.ON;
    }

    public void install(IProgressMonitor monitor, RuyiInstallWizard.InstallationListener listener) throws Exception {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Installing Ruyi", (int)100);
        try {
            try {
                this.prepareInstallation(listener);
                this.downloadRuyi(monitor, listener);
                listener.logMessage("Setting executable permissions...");
                this.setExecutablePermissions(this.installPath, listener);
                listener.logMessage("Ruyi " + this.getVersionFromPackage() + " installed successfully");
                this.validateInstallation(this.installPath, listener);
                listener.logMessage("Installation completed successfully");
                this.ruyiConfig(this.installPath, listener);
            }
            catch (Exception e) {
                listener.logMessage("Installation failed: " + e.getMessage());
                throw e;
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private void prepareInstallation(RuyiInstallWizard.InstallationListener listener) throws Exception {
        FileStore store;
        listener.logMessage("Verifying installation directory: " + this.installPath);
        Path path = Paths.get(this.installPath, new String[0]);
        System.out.println("Ruyi\u5305\u7ba1\u7406\u5668\u5b89\u88c5\u5730\u5740\uff1a" + String.valueOf(path));
        if (!Files.exists(path, new LinkOption[0])) {
            listener.logMessage("Directory does not exist, attempting to create...");
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                listener.logMessage("Directory created successfully.");
            }
            catch (IOException e) {
                throw new Exception("Failed to create installation directory: " + e.getMessage(), e);
            }
        } else {
            listener.logMessage("Directory already exists.");
        }
        listener.progressChanged(5, "Directory ready");
        listener.logMessage("Checking available disk space...");
        try {
            store = Files.getFileStore(path);
        }
        catch (IOException e) {
            throw new Exception("Cannot access filesystem: " + e.getMessage(), e);
        }
        long freeSpaceBytes = store.getUsableSpace();
        long requiredSpaceBytes = 524288000L;
        if (freeSpaceBytes < requiredSpaceBytes) {
            BigDecimal requiredMb = BigDecimal.valueOf(requiredSpaceBytes).divide(BigDecimal.valueOf(0x100000L), 1, RoundingMode.HALF_UP);
            BigDecimal freeMb = BigDecimal.valueOf(freeSpaceBytes).divide(BigDecimal.valueOf(0x100000L), 1, RoundingMode.HALF_UP);
            throw new Exception(String.format("\u9700\u8981\u81f3\u5c11 %s MB \u7a7a\u95f4\uff0c\u5f53\u524d\u53ef\u7528 %s MB", requiredMb.stripTrailingZeros().toPlainString(), freeMb.stripTrailingZeros().toPlainString()));
        }
        BigDecimal freeMb = BigDecimal.valueOf(freeSpaceBytes).divide(BigDecimal.valueOf(0x100000L), 1, RoundingMode.HALF_UP);
        String msg = "\u78c1\u76d8\u7a7a\u95f4\u5145\u8db3 (\u53ef\u7528: " + freeMb.toPlainString() + " MB)";
        listener.logMessage(msg);
        listener.progressChanged(10, "\u51c6\u5907\u5b8c\u6210");
    }

    private void downloadRuyi(IProgressMonitor monitor, RuyiInstallWizard.InstallationListener listener) throws Exception {
        String archSuffix = SystemInfo.detectArchitecture().getSuffix();
        this.latestRelease = RuyiApi.getLatestRelease(archSuffix);
        Path ruyiInstallPath = Paths.get(this.installPath, "ruyi");
        String[] downloadSources = new String[]{this.latestRelease.getMirrorUrl(), this.latestRelease.getGithubUrl()};
        Throwable lastException = null;
        int[] lastPercent = new int[1];
        monitor.beginTask("Downloading Ruyi", 100);
        monitor.worked(0);
        int i = 0;
        while (i < downloadSources.length) {
            String sourceName = i == 0 ? "\u955c\u50cf\u6e90" : "GitHub\u6e90";
            String ruyiDownloadUrl = downloadSources[i];
            System.out.println("ruyiDownloadUrl===" + ruyiDownloadUrl);
            System.out.println("ruyiInstallPath===" + String.valueOf(ruyiInstallPath));
            try {
                listener.logMessage(String.format("\u5c1d\u8bd5\u4ece%s\u4e0b\u8f7d: %s", sourceName, ruyiDownloadUrl));
                RuyiNetworkUtils.downloadFile(ruyiDownloadUrl, ruyiInstallPath.toString(), monitor, (transferred, total) -> {
                    if (total <= 0L) {
                        return;
                    }
                    int percent = (int)((double)transferred.longValue() / (double)total.longValue() * 100.0);
                    if ((percent = Math.min(percent, 100)) > lastPercent[0]) {
                        monitor.worked(percent - lastPercent[0]);
                        nArray[0] = percent;
                    }
                    listener.progressChanged(percent, String.format("\u4ece%s\u4e0b\u8f7d\u4e2d (%d/%d KB)", sourceName, transferred / 1024L, total / 1024L));
                });
                if (lastPercent[0] < 100) {
                    monitor.worked(100 - lastPercent[0]);
                    listener.progressChanged(100, "\u4e0b\u8f7d\u5b8c\u6210");
                }
                listener.logMessage("\u4e0b\u8f7d\u6210\u529f");
                return;
            }
            catch (Exception e) {
                lastException = e;
                listener.logMessage(String.format("%s\u4e0b\u8f7d\u5931\u8d25: %s", sourceName, e.getMessage()));
                if (i < downloadSources.length - 1) {
                    try {
                        Files.deleteIfExists(ruyiInstallPath);
                        listener.logMessage("\u5df2\u6e05\u7406\u5931\u8d25\u4e0b\u8f7d\u7684\u90e8\u5206\u6587\u4ef6");
                    }
                    catch (IOException ioEx) {
                        listener.logMessage("\u6e05\u7406\u90e8\u5206\u6587\u4ef6\u5931\u8d25: " + ioEx.getMessage());
                    }
                }
                ++i;
            }
        }
        throw new Exception(String.format("\u6240\u6709\u4e0b\u8f7d\u5c1d\u8bd5\u5747\u5931\u8d25\u3002\u6700\u540e\u9519\u8bef: %s", lastException != null ? lastException.getMessage() : "\u672a\u77e5\u9519\u8bef"), lastException);
    }

    private void prepareExecutable(Path source, Path target, RuyiInstallWizard.InstallationListener listener) throws Exception {
        listener.logMessage("Preparing executable...");
        try {
            if (!target.toFile().setExecutable(true)) {
                throw new Exception("Failed to set executable permission");
            }
        }
        catch (SecurityException e) {
            throw new Exception("Permission denied when setting executable flag", e);
        }
        listener.logMessage("Executable prepared: " + String.valueOf(target));
    }

    private void addToPathIfNeeded(String path, RuyiInstallWizard.InstallationListener listener) throws Exception {
        Path ruyiExecutable = Paths.get(path, "ruyi");
        if (PathUtils.isPathConfigured(path) && Files.isExecutable(ruyiExecutable)) {
            listener.logMessage("PATH already contains: " + path);
            return;
        }
        if (!this.showConfirmationDialog("PATH Configuration", "\u9700\u8981\u6dfb\u52a0\u5b89\u88c5\u76ee\u5f55\u5230PATH\u53d8\u91cf\u5e76\u8bbe\u7f6e\u53ef\u6267\u884c\u6743\u9650")) {
            throw new Exception("User declined configuration");
        }
        String command = String.format("echo 'export PATH=\"%s:$PATH\"' >> ~/.bashrc && chmod +x %s && source ~/.bashrc", path, ruyiExecutable.toString());
        this.executeWithPrivilege(command, listener);
        if (!Files.isExecutable(ruyiExecutable)) {
            String perms = Files.exists(ruyiExecutable, new LinkOption[0]) ? "Current permissions: " + String.valueOf(Files.getPosixFilePermissions(ruyiExecutable, new LinkOption[0])) : "File does not exist";
            throw new Exception(String.format("Permission verification failed for: %s\n%s", ruyiExecutable, perms));
        }
        listener.logMessage("\u9a8c\u8bc1\u6210\u529f: " + String.valueOf(ruyiExecutable) + " \u5df2\u83b7\u5f97\u53ef\u6267\u884c\u6743\u9650");
    }

    /*
     * Unable to fully structure code
     */
    private void setExecutablePermissions(String path, RuyiInstallWizard.InstallationListener listener) throws Exception {
        ruyipath = Paths.get(path, new String[]{"ruyi"});
        file = new File(ruyipath.toString());
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + path);
        }
        if (file.canExecute()) {
            if (listener != null) {
                listener.logMessage(path + " is already executable");
            }
            return;
        }
        success = file.setExecutable(true, false);
        if (!success) {
            try {
                filePath = file.toPath();
                perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(filePath, new LinkOption[0]));
                perms.add(PosixFilePermission.OWNER_EXECUTE);
                perms.add(PosixFilePermission.GROUP_EXECUTE);
                perms.add(PosixFilePermission.OTHERS_EXECUTE);
                Files.setPosixFilePermissions(filePath, perms);
                if (listener == null) ** GOTO lbl29
                listener.logMessage("Successfully set executable permissions using POSIX API: " + path);
            }
            catch (UnsupportedOperationException v0) {
                throw new Exception("Failed to set executable permissions on non-POSIX system: " + path);
            }
        } else if (listener != null) {
            listener.logMessage("Successfully set executable permissions: " + path);
        }
lbl29:
        // 5 sources

        if (!file.canExecute()) {
            throw new Exception("Failed to set executable permissions for: " + path + ". You may need root/sudo privileges.");
        }
    }

    private boolean showConfirmationDialog(String title, String message) {
        try {
            return new ProcessBuilder("zenity", "--question", "--title=" + title, "--text=" + message, "--width=300").start().waitFor() == 0;
        }
        catch (Exception exception) {
            System.out.printf("%s (y/N): ", message);
            return new Scanner(System.in).nextLine().equalsIgnoreCase("y");
        }
    }

    private void executeWithPrivilege(String command, RuyiInstallWizard.InstallationListener listener) throws Exception {
        String expandedCmd = command.replace("~", System.getProperty("user.home"));
        String[] cmd = new String[]{"pkexec", "bash", "-c", expandedCmd};
        try {
            Process proc = new ProcessBuilder(cmd).redirectErrorStream(true).start();
            StringBuilder output = new StringBuilder();
            Throwable throwable = null;
            Object var8_11 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                    listener.logMessage(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int exitCode = proc.waitFor();
            if (exitCode != 0) {
                throw new Exception(String.format("Command failed (exit code %d): %s\nOutput: %s", exitCode, command, output.toString()));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new Exception("Failed to execute privileged command: " + e.getMessage(), e);
        }
    }

    private void validateInstallation(String ruyiPath, RuyiInstallWizard.InstallationListener listener) throws Exception {
        listener.logMessage("Validating installation...");
        RuyiVersion version = RuyiCommand.getInstalledVersion(ruyiPath);
        if (version == null) {
            listener.logMessage("There are problems in the operation ruyi -V.");
        }
        listener.logMessage("Ruyi " + version.toString() + " install successful.");
    }

    private void ruyiConfig(String ruyiPath, RuyiInstallWizard.InstallationListener listener) throws Exception {
        listener.logMessage("Ruyi Config...");
        RuyiCommand.setRepoRemote(ruyiPath, this.repoUrls[0].getUrl());
        listener.logMessage("ruyi config set repo.remote successful. \n repo.remote is:" + RuyiCommand.getRepoRemote(ruyiPath));
        RuyiCommand.updateRuyi(ruyiPath);
        listener.logMessage("ruyi update successful");
        RuyiCommand.setTelemetry(ruyiPath, this.telemetryStatus);
        listener.logMessage("ruyi telemetry set successful:" + RuyiCommand.getTelemetryStatus(ruyiPath));
        listener.logMessage("Config successful");
    }

    private void cleanFailedDownload(Path file, RuyiInstallWizard.InstallationListener listener) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            listener.logMessage("Warning: Failed to clean up temporary file - " + e.getMessage());
        }
    }

    private String getVersionFromPackage() throws Exception {
        Path versionFile = Paths.get(this.installPath + "/ruyi", "VERSION");
        if (Files.exists(versionFile, new LinkOption[0])) {
            return RuyiFileUtils.readFileContent(versionFile.toString()).trim();
        }
        return "unknown";
    }

    public String getDefaultInstallPath() {
        return DEFAULT_INSTALL_PATH.toString();
    }

    public void setInstallPath(String installPath) {
        this.installPath = installPath;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public void setRepoUrls(RepoConfig[] selectedRepoConfigs) {
        this.repoUrls = selectedRepoConfigs;
    }

    public void cleanup() throws Exception {
        this.logger.logInfo("Cleaning up installation files");
        Path installDir = Paths.get(this.installPath, new String[0]);
        if (Files.exists(installDir, new LinkOption[0])) {
            RuyiFileUtils.deleteRecursively(installDir);
        }
    }
}

