/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.services;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.ruyisdk.ruyi.Activator;
import org.ruyisdk.ruyi.util.RuyiFileUtils;
import org.ruyisdk.ruyi.util.RuyiLogger;

public class RuyiCli {
    private static final RuyiLogger LOGGER = Activator.getLogger();

    public static List<ProfileInfo> listProfiles() {
        ArrayList<ProfileInfo> out = new ArrayList<ProfileInfo>();
        try {
            String line;
            RunResult result = RuyiCli.runRuyi(Arrays.asList("--porcelain", "list", "profiles"));
            String output = result.getOutput();
            int exit = result.getExitCode();
            if (exit != 0 && (output == null || output.isEmpty())) {
                result = RuyiCli.runRuyi(Arrays.asList("list", "profiles"));
                output = result.getOutput();
            }
            if (output == null || output.isEmpty()) {
                return out;
            }
            String trimmed = output.trim();
            if (trimmed.startsWith("[") || trimmed.startsWith("{")) {
                try {
                    JSONArray arr = new JSONArray(trimmed);
                    int i = 0;
                    while (i < arr.length()) {
                        JSONObject o = arr.getJSONObject(i);
                        String name = o.optString("name", o.optString("id", ""));
                        String quirks = o.optString("quirks", "");
                        out.add(new ProfileInfo(name, quirks));
                        ++i;
                    }
                    return out;
                }
                catch (Exception exception) {}
            }
            Pattern namePtn = Pattern.compile("^\\s*([^\\s(]+)", 2);
            Pattern quirksPtn = Pattern.compile("needs quirks:\\s*\\{([^}]*)\\}", 2);
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.getBytes())));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                Matcher m = namePtn.matcher(line);
                String name = null;
                if (m.find()) {
                    name = m.group(1);
                }
                String quirks = "";
                Matcher q = quirksPtn.matcher(line);
                if (q.find()) {
                    quirks = q.group(1).trim();
                    quirks = quirks.replaceAll("\\'", "").replaceAll("\\\"", "");
                }
                if (name == null || name.isEmpty()) continue;
                out.add(new ProfileInfo(name, quirks));
            }
        }
        catch (Exception exception) {}
        return out;
    }

    public static List<NewsListItemInfo> listNewsItems(boolean onlyUnread) {
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--porcelain");
            args.add("news");
            args.add("list");
            if (onlyUnread) {
                args.add("--new");
            }
            RunResult result = RuyiCli.runRuyi(args);
            return RuyiCli.parseNewsListFromString(result.getOutput());
        }
        catch (Exception exception) {
            return new ArrayList<NewsListItemInfo>();
        }
    }

    public static NewsReadResult readNewsItem(String idOrOrd) {
        block3: {
            try {
                if (idOrOrd != null && !idOrOrd.isBlank()) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        List<String> args = Arrays.asList("--porcelain", "news", "read", "--quiet", idOrOrd);
        RunResult result = RuyiCli.runRuyi(args, 3);
        return RuyiCli.parseNewsReadFromString(result.getOutput());
    }

    public static List<NewsListItemInfo> parseNewsListFromString(String input) {
        ArrayList<NewsListItemInfo> out = new ArrayList<NewsListItemInfo>();
        if (input == null || input.isBlank()) {
            return out;
        }
        try {
            for (JSONObject o : RuyiCli.parseConcatenatedJsonObjects(input)) {
                String ty;
                if (o == null || !"newsitem-v1".equalsIgnoreCase(ty = o.optString("ty", null))) continue;
                String id = o.optString("id", null);
                Integer ord = o.optIntegerObject("ord", null);
                Boolean isRead = o.optBooleanObject("is_read", null);
                JSONArray langs = o.optJSONArray("langs");
                String title = RuyiCli.chooseNewsDisplayTitle(langs);
                out.add(new NewsListItemInfo(id, ord, isRead, title));
            }
        }
        catch (Exception exception) {}
        return out;
    }

    public static NewsReadResult parseNewsReadFromString(String input) {
        JSONObject o;
        block6: {
            List<JSONObject> objs;
            block5: {
                if (input == null || input.isBlank()) {
                    return null;
                }
                try {
                    objs = RuyiCli.parseConcatenatedJsonObjects(input);
                    if (!objs.isEmpty()) break block5;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            o = objs.get(0);
            if (o != null) break block6;
            return null;
        }
        String id = o.optString("id", null);
        Integer ord = o.optIntegerObject("ord", null);
        Boolean isRead = o.optBooleanObject("is_read", null);
        JSONArray langs = o.optJSONArray("langs");
        String title = RuyiCli.chooseNewsDisplayTitle(langs);
        String content = RuyiCli.chooseNewsContent(langs);
        return new NewsReadResult(id, ord, isRead, title, content);
    }

    private static List<JSONObject> parseConcatenatedJsonObjects(String input) {
        ArrayList<JSONObject> out = new ArrayList<JSONObject>();
        if (input == null) {
            return out;
        }
        try {
            char c;
            JSONTokener t = new JSONTokener(input);
            while ((c = t.nextClean()) != '\u0000') {
                t.back();
                Object v = t.nextValue();
                if (v instanceof JSONObject) {
                    out.add((JSONObject)v);
                    continue;
                }
                if (!(v instanceof JSONArray)) continue;
                JSONArray arr = (JSONArray)v;
                int i = 0;
                while (i < arr.length()) {
                    Object el = arr.get(i);
                    if (el instanceof JSONObject) {
                        out.add((JSONObject)el);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        return out;
    }

    private static String chooseNewsDisplayTitle(JSONArray langs) {
        JSONObject best = RuyiCli.chooseBestNewsLang(langs);
        if (best == null) {
            return null;
        }
        return best.optString("display_title", null);
    }

    private static String chooseNewsContent(JSONArray langs) {
        JSONObject best = RuyiCli.chooseBestNewsLang(langs);
        if (best == null) {
            return null;
        }
        return best.optString("content", null);
    }

    private static JSONObject chooseBestNewsLang(JSONArray langs) {
        String lang;
        JSONObject o;
        if (langs == null || langs.length() == 0) {
            return null;
        }
        JSONObject first = null;
        String sysLang = Locale.getDefault() == null ? "" : Locale.getDefault().toString();
        int i = 0;
        while (i < langs.length()) {
            o = langs.optJSONObject(i);
            if (o != null) {
                if (first == null) {
                    first = o;
                }
                if ("en_US".equalsIgnoreCase(lang = o.optString("lang", ""))) {
                    return o;
                }
            }
            ++i;
        }
        if (!sysLang.isEmpty()) {
            i = 0;
            while (i < langs.length()) {
                o = langs.optJSONObject(i);
                if (o != null && sysLang.equalsIgnoreCase(lang = o.optString("lang", ""))) {
                    return o;
                }
                ++i;
            }
        }
        return first;
    }

    private static String readAll(Process p, int timeout) throws InterruptedException {
        if (timeout < 0) {
            timeout = Integer.MAX_VALUE;
        }
        CompletableFuture<String> outputFuture = CompletableFuture.supplyAsync(() -> p.inputReader().lines().collect(Collectors.joining("\n")));
        if (!p.waitFor(timeout, TimeUnit.SECONDS)) {
            p.destroyForcibly();
        }
        try {
            return outputFuture.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static RunResult runRuyi(List<String> args) {
        return RuyiCli.runRuyi(args, -1);
    }

    /*
     * Unable to fully structure code
     */
    private static RunResult runRuyi(List<String> args, int timeout) {
        block14: {
            install = null;
            try {
                install = RuyiFileUtils.getInstallPath();
            }
            catch (Exception v0) {}
            if (install == null || install.isBlank()) {
                return new RunResult(-1, "Ruyi install path not configured (RuyiFileUtils.getInstallPath() returned empty)");
            }
            try {
                exe = install + File.separator + "ruyi";
                cmd = new ArrayList<String>();
                cmd.add(exe);
                if (args != null && !args.isEmpty()) {
                    cmd.addAll(args);
                }
                pb = new ProcessBuilder(cmd);
                pb.redirectErrorStream(true);
                p = pb.start();
                rawOutput = RuyiCli.readAll(p, timeout);
                exit = p.exitValue();
                cmdStrBuilder = new StringBuilder();
                i = 0;
                while (i < cmd.size()) {
                    part = cmd.get(i);
                    if (part.contains(" ")) {
                        cmdStrBuilder.append('\'').append(part).append('\'');
                    } else {
                        cmdStrBuilder.append(part);
                    }
                    if (i < cmd.size() - 1) {
                        cmdStrBuilder.append(' ');
                    }
                    ++i;
                }
                cmdString = cmdStrBuilder.toString();
                v1 = output = rawOutput == null ? "" : rawOutput;
                if (exit != 0) {
                    hint = "\nCommand: " + cmdString + "\n";
                    return new RunResult(exit, output + hint);
                }
                return new RunResult(exit, output);
            }
            catch (IOException | InterruptedException e) {
                cmdStrBuilder = new StringBuilder();
                if (args == null) break block14;
                cmdStrBuilder.append((String)(install == null ? "ruyi" : install + File.separator + "ruyi"));
                ** for (a : args)
            }
lbl-1000:
            // 1 sources

            {
                cmdStrBuilder.append(' ');
                if (a.contains(" ")) {
                    cmdStrBuilder.append('\'').append(a).append('\'');
                    continue;
                }
                cmdStrBuilder.append(a);
                continue;
            }
        }
        cmdString = cmdStrBuilder.toString();
        v2 = out = e.getMessage() == null ? "" : e.getMessage();
        if (cmdString.isEmpty()) {
            return new RunResult(-1, out);
        }
        return new RunResult(-1, out + "\nCommand: " + cmdString + "\n");
    }

    public static RunResult run(List<String> args) {
        return RuyiCli.runRuyi(args);
    }

    public static RunResult update() {
        return RuyiCli.run(Arrays.asList("--porcelain", "update"));
    }

    public static RunResult installPackage(String name, String version) {
        if (name == null || name.isBlank() || version == null || version.isBlank()) {
            return new RunResult(-1, "Invalid package name or version");
        }
        String atom = name + "(" + version + ")";
        List<String> args = Arrays.asList("--porcelain", "install", atom);
        RunResult result = RuyiCli.run(args);
        return result;
    }

    public static RunResult createVenv(String path, String toolchainName, String toolchainVersion, String profile, String emulatorName, String emulatorVersion) {
        if (path == null || path.isBlank()) {
            return new RunResult(-1, "Empty venv path");
        }
        if (toolchainName == null || toolchainName.isBlank() || toolchainVersion == null || toolchainVersion.isBlank()) {
            return new RunResult(-1, "Invalid toolchain");
        }
        if (profile == null || profile.isBlank()) {
            return new RunResult(-1, "Invalid profile");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--porcelain");
        args.add("venv");
        args.add("--toolchain");
        args.add(toolchainName + "(" + toolchainVersion + ")");
        if (emulatorName != null && !emulatorName.isBlank() && emulatorVersion != null && !emulatorVersion.isBlank()) {
            args.add("--emulator");
            args.add(emulatorName + "(" + emulatorVersion + ")");
        }
        args.add(profile);
        args.add(path);
        return RuyiCli.run(args);
    }

    private static List<String> extractJsonObjects(String s) {
        ArrayList<String> objs = new ArrayList<String>();
        if (s == null || s.isEmpty()) {
            return objs;
        }
        int depth = 0;
        int start = -1;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '{') {
                if (depth == 0) {
                    start = i;
                }
                ++depth;
            } else if (c == '}' && --depth == 0 && start >= 0) {
                objs.add(s.substring(start, i + 1));
                start = -1;
            }
            ++i;
        }
        return objs;
    }

    public static List<ToolchainInfo> listToolchains() {
        ArrayList<ToolchainInfo> out = new ArrayList<ToolchainInfo>();
        try {
            RunResult result = RuyiCli.runRuyi(Arrays.asList("--porcelain", "list", "--category-is", "toolchain", "--name-contains", ""));
            String output = result.getOutput();
            if (output == null || output.isEmpty()) {
                return out;
            }
            out.addAll(RuyiCli.parseToolchainsFromString(output));
        }
        catch (Exception exception) {}
        return out;
    }

    public static List<ToolchainInfo> parseToolchainsFromString(String input) {
        ArrayList<ToolchainInfo> out = new ArrayList<ToolchainInfo>();
        try {
            if (input == null || input.isEmpty()) {
                return out;
            }
            List<String> objs = RuyiCli.extractJsonObjects(input);
            for (String jo : objs) {
                if (jo == null || jo.isBlank()) continue;
                try {
                    String pkgName;
                    JSONObject o = new JSONObject(jo);
                    String category = o.optString("category", "");
                    if (!"toolchain".equalsIgnoreCase(category) || (pkgName = o.optString("name", "").trim()).isEmpty()) continue;
                    ArrayList<String> versions = new ArrayList<String>();
                    JSONArray vers = o.optJSONArray("vers");
                    if (vers != null && vers.length() > 0) {
                        int vi = 0;
                        while (vi < vers.length()) {
                            try {
                                String sem;
                                JSONObject v = vers.optJSONObject(vi);
                                if (v != null && (sem = v.optString("semver", v.optString("version", "")).trim()) != null && !sem.isEmpty()) {
                                    versions.add(sem);
                                }
                            }
                            catch (Exception exception) {}
                            ++vi;
                        }
                    }
                    if (versions.isEmpty()) continue;
                    out.add(new ToolchainInfo(pkgName, versions));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return out;
    }

    public static List<EmulatorInfo> listEmulators() {
        ArrayList<EmulatorInfo> out = new ArrayList<EmulatorInfo>();
        try {
            RunResult result = RuyiCli.runRuyi(Arrays.asList("--porcelain", "list", "--category-is", "emulator", "--name-contains", ""));
            String output = result.getOutput();
            if (output == null || output.isEmpty()) {
                return out;
            }
            out.addAll(RuyiCli.parseEmulatorsFromString(output));
        }
        catch (Exception exception) {}
        return out;
    }

    public static List<EmulatorInfo> parseEmulatorsFromString(String input) {
        ArrayList<EmulatorInfo> out = new ArrayList<EmulatorInfo>();
        try {
            if (input == null || input.isEmpty()) {
                return out;
            }
            List<String> objs = RuyiCli.extractJsonObjects(input);
            for (String jo : objs) {
                if (jo == null || jo.isBlank()) continue;
                try {
                    String pkgName;
                    JSONObject o = new JSONObject(jo);
                    String category = o.optString("category", "");
                    if (!"emulator".equalsIgnoreCase(category) || (pkgName = o.optString("name", "").trim()).isEmpty()) continue;
                    ArrayList<String> versions = new ArrayList<String>();
                    JSONArray vers = o.optJSONArray("vers");
                    if (vers != null && vers.length() > 0) {
                        int vi = 0;
                        while (vi < vers.length()) {
                            try {
                                String sem;
                                JSONObject v = vers.optJSONObject(vi);
                                if (v != null && (sem = v.optString("semver", v.optString("version", "")).trim()) != null && !sem.isEmpty()) {
                                    versions.add(sem);
                                }
                            }
                            catch (Exception exception) {}
                            ++vi;
                        }
                    }
                    if (versions.isEmpty()) continue;
                    out.add(new EmulatorInfo(pkgName, versions));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return out;
    }

    public static List<VenvInfo> listVenvs() {
        ArrayList<VenvInfo> out = new ArrayList<VenvInfo>();
        try {
            String home = System.getProperty("user.home");
            if (home == null) {
                return out;
            }
            File homeDir = new File(home);
            File[] children = homeDir.listFiles();
            if (children == null) {
                return out;
            }
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                if (dir.isDirectory()) {
                    String sysroot;
                    String profile;
                    String path;
                    File binActivate = new File(dir, "bin/activate");
                    File scriptsActivate = new File(dir, "Scripts/activate");
                    if (binActivate.exists() || scriptsActivate.exists()) {
                        path = dir.getAbsolutePath();
                        profile = dir.getName();
                        sysroot = new File(dir, "sysroot").getAbsolutePath();
                        out.add(new VenvInfo(path, profile, sysroot, Boolean.TRUE));
                    }
                    if (dir.getName().toLowerCase().endsWith("-venv") || dir.getName().equalsIgnoreCase("ruyivenv")) {
                        path = dir.getAbsolutePath();
                        profile = dir.getName().replaceAll("-venv$", "");
                        sysroot = new File(dir, "sysroot").getAbsolutePath();
                        out.add(new VenvInfo(path, profile, sysroot, Boolean.FALSE));
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return out;
    }

    public static class EmulatorInfo {
        private final String name;
        private final List<String> versions;

        public EmulatorInfo(String name, List<String> versions) {
            this.name = name;
            this.versions = versions == null ? new ArrayList<String>() : new ArrayList<String>(versions);
        }

        public String getName() {
            return this.name;
        }

        public List<String> getVersions() {
            return Collections.unmodifiableList(this.versions);
        }
    }

    public static class NewsListItemInfo {
        private final String id;
        private final Integer ord;
        private final Boolean read;
        private final String title;

        public NewsListItemInfo(String id, Integer ord, Boolean read, String title) {
            this.id = id;
            this.ord = ord;
            this.read = read;
            this.title = title;
        }

        public String getId() {
            return this.id;
        }

        public Integer getOrd() {
            return this.ord;
        }

        public Boolean isRead() {
            return this.read;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class NewsReadResult {
        private final String id;
        private final Integer ord;
        private final Boolean read;
        private final String title;
        private final String content;

        public NewsReadResult(String id, Integer ord, Boolean read, String title, String content) {
            this.id = id;
            this.ord = ord;
            this.read = read;
            this.title = title;
            this.content = content;
        }

        public String getId() {
            return this.id;
        }

        public Integer getOrd() {
            return this.ord;
        }

        public Boolean isRead() {
            return this.read;
        }

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static class ProfileInfo {
        private final String name;
        private final String quirks;

        public ProfileInfo(String name, String quirks) {
            this.name = name;
            this.quirks = quirks;
        }

        public String getName() {
            return this.name;
        }

        public String getQuirks() {
            return this.quirks;
        }
    }

    public static class RunResult {
        private final int exitCode;
        private final String output;

        public RunResult(int exitCode, String output) {
            this.exitCode = exitCode;
            this.output = output == null ? "" : output;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }
    }

    public static class ToolchainInfo {
        private final String name;
        private final List<String> versions;

        public ToolchainInfo(String name, List<String> versions) {
            this.name = name;
            this.versions = versions == null ? new ArrayList<String>() : new ArrayList<String>(versions);
        }

        public String getName() {
            return this.name;
        }

        public List<String> getVersions() {
            return Collections.unmodifiableList(this.versions);
        }
    }

    public static class VenvInfo {
        private final String path;
        private final String profile;
        private final String sysroot;
        private final Boolean activated;

        public VenvInfo(String path, String profile, String sysroot, Boolean activated) {
            this.path = path;
            this.profile = profile;
            this.sysroot = sysroot;
            this.activated = activated;
        }

        public String getPath() {
            return this.path;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getSysroot() {
            return this.sysroot;
        }

        public Boolean getActivated() {
            return this.activated;
        }
    }
}

