/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.preferences;

import java.io.IOException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.ruyisdk.ruyi.services.RuyiProperties;
import org.ruyisdk.ruyi.util.RuyiFileUtils;

public class RuyiInstallPathPreference {
    private final Composite parent;
    private Text ruyiInstallPathText;

    public RuyiInstallPathPreference(Composite parent) {
        this.parent = parent;
    }

    public void createSection() {
        Composite container = new Composite(this.parent, 0);
        GridData gd = new GridData(4, 128, true, false);
        gd.verticalIndent = 0;
        container.setLayoutData((Object)gd);
        container.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(container, 0);
        label.setText("Ruyi Installation Directory:");
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.ruyiInstallPathText = new Text(container, 2048);
        this.ruyiInstallPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ruyiInstallPathText.setText(RuyiFileUtils.getInstallPath());
        Button browse = new Button(container, 8);
        browse.setText("Browse...");
        browse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browse.addListener(13, e -> {
            DirectoryDialog dialog = new DirectoryDialog(Display.getDefault().getActiveShell());
            dialog.setFilterPath(this.ruyiInstallPathText.getText());
            String path = dialog.open();
            if (path != null) {
                this.ruyiInstallPathText.setText(path);
            }
        });
    }

    public void defaultedInstallPath() {
        this.ruyiInstallPathText.setText(RuyiFileUtils.getDefaultInstallPath().toString());
    }

    public void saveInstallPath() throws IOException {
        String newPath = this.ruyiInstallPathText.getText();
        RuyiProperties.setInstallPath(newPath);
    }

    public String getTextPath() {
        return this.ruyiInstallPathText.getText().trim();
    }
}

