/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.preferences;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.ruyisdk.ruyi.Activator;
import org.ruyisdk.ruyi.preferences.AutomaticCheckPreference;
import org.ruyisdk.ruyi.preferences.RepoConfigPreference;
import org.ruyisdk.ruyi.preferences.RuyiInstallPathPreference;
import org.ruyisdk.ruyi.preferences.TelemetryPreference;
import org.ruyisdk.ruyi.util.StatusUtil;

public class RuyiConfigPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private RuyiInstallPathPreference installPreference;
    private RepoConfigPreference repoPreference;
    private TelemetryPreference telemetryPreference;
    private AutomaticCheckPreference automaticCheckPreference;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        content.setLayout((Layout)new GridLayout(1, false));
        this.automaticCheckPreference = new AutomaticCheckPreference(content);
        this.automaticCheckPreference.createSection();
        this.installPreference = new RuyiInstallPathPreference(content);
        this.installPreference.createSection();
        this.repoPreference = new RepoConfigPreference(content);
        this.repoPreference.createSection();
        this.telemetryPreference = new TelemetryPreference(content);
        this.telemetryPreference.createSection();
    }

    private void printControlHierarchy(Composite comp, int level) {
        String indent = String.join((CharSequence)"", Collections.nCopies(level, "  "));
        System.out.println(indent + String.valueOf(comp) + " " + String.valueOf(comp.getLayout()));
        Control[] controlArray = comp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            System.out.println(indent + " |- " + String.valueOf(c) + " " + String.valueOf(c.getLayoutData()));
            if (c instanceof Composite) {
                this.printControlHierarchy((Composite)c, level + 1);
            }
            ++n2;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.automaticCheckPreference.defaultedAutomaticDetectionState();
        this.installPreference.defaultedInstallPath();
        this.repoPreference.defaultedRepoState();
        this.telemetryPreference.defaultedTelemetryState();
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Defaults Restored", (String)"All settings have been reset to default values");
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            this.applySettingsToRuntime();
        }
        return result;
    }

    protected void performApply() {
        super.performApply();
        this.applySettingsToRuntime();
        StatusUtil.showInfo("Settings applied successfully");
    }

    private void applySettingsToRuntime() {
        try {
            this.automaticCheckPreference.setAutomaticDetection();
            this.installPreference.saveInstallPath();
            this.repoPreference.saveRepoConfigs();
            this.telemetryPreference.saveTelemetryConfigs();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

