/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.ruyisdk.core.ruyi.model.RepoConfig;
import org.ruyisdk.ruyi.services.RuyiProperties;

public class RepoConfigPreference {
    private final Composite parent;
    private Button[] repoCheckboxes;
    private Text customRepoText;
    private RepoConfig[] configs;

    public RepoConfigPreference(Composite parent) {
        this.parent = parent;
    }

    public void createSection() {
        Group group = new Group(this.parent, 0);
        group.setText("Package Repositories");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        this.configs = this.getRepoConfigs();
        this.repoCheckboxes = new Button[this.configs.length];
        int i = 0;
        while (i < this.configs.length) {
            if ("Custom".equals(this.configs[i].getName())) {
                this.createCustomRepoUi((Composite)group, this.configs[i], i);
            } else {
                this.createStandardRepoUi((Composite)group, this.configs[i], i);
            }
            ++i;
        }
    }

    private void createCustomRepoUi(Composite parent, RepoConfig config, int index) {
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)new GridLayout(2, false));
        row.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.repoCheckboxes[index] = new Button(row, 32);
        this.repoCheckboxes[index].setText(config.getName());
        this.repoCheckboxes[index].setSelection(config.getCheckState());
        this.repoCheckboxes[index].addListener(13, e -> this.customRepoText.setEnabled(this.repoCheckboxes[index].getSelection()));
        String customUrl = RuyiProperties.getCustomMirror();
        this.customRepoText = new Text(row, 2048);
        this.customRepoText.setText(customUrl);
        this.customRepoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.customRepoText.setEnabled(!customUrl.isEmpty());
    }

    private void createStandardRepoUi(Composite parent, RepoConfig config, int index) {
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)new GridLayout(1, false));
        row.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.repoCheckboxes[index] = new Button(parent, 32);
        this.repoCheckboxes[index].setText(config.getName() + ": " + config.getUrl());
        this.repoCheckboxes[index].setSelection(config.getCheckState());
        this.repoCheckboxes[index].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public RepoConfig[] getRepoDefault() {
        return new RepoConfig[]{new RepoConfig("China ISCAS Mirror", "https://mirror.iscas.ac.cn/git/ruyisdk/packages-index.git", 1, true), new RepoConfig("GitHub Repo", "https://github.com/ruyisdk/packages-index.git", 2, true), new RepoConfig("Custom", "", 0, false)};
    }

    public RepoConfig[] getRepoConfigs() {
        return new RepoConfig[]{new RepoConfig("China ISCAS Mirror", "https://mirror.iscas.ac.cn/git/ruyisdk/packages-index.git", 1, RuyiProperties.isIscasMirrorChecked()), new RepoConfig("GitHub Repo", "https://github.com/ruyisdk/packages-index.git", 2, RuyiProperties.isGithubMirrorChecked()), new RepoConfig("Custom", RuyiProperties.getCustomMirror(), 0, RuyiProperties.isCustomMirrorChecked())};
    }

    public RepoConfig[] getSelectedRepos() {
        ArrayList<RepoConfig> selectedConfigs = new ArrayList<RepoConfig>();
        int i = 0;
        while (i < this.repoCheckboxes.length) {
            if (this.repoCheckboxes[i].getSelection()) {
                if ("Custom".equals(this.configs[i].getName())) {
                    this.configs[i].setUrl(this.customRepoText.getText().trim());
                }
                if (!this.configs[i].getUrl().isEmpty()) {
                    selectedConfigs.add(this.configs[i]);
                }
            }
            ++i;
        }
        selectedConfigs.sort(Comparator.comparingInt(RepoConfig::getPriority));
        return selectedConfigs.toArray(new RepoConfig[0]);
    }

    public void defaultedRepoState() {
        RepoConfig[] defaultConfigs = this.getRepoDefault();
        int i = 0;
        while (i < defaultConfigs.length) {
            if ("Custom".equals(defaultConfigs[i].getName())) {
                this.customRepoText.setText("");
                this.customRepoText.setEnabled(false);
                this.repoCheckboxes[i].setSelection(false);
            } else {
                this.repoCheckboxes[i].setSelection(defaultConfigs[i].getCheckState());
            }
            ++i;
        }
    }

    public void saveRepoConfigs() throws IOException {
        int i = 0;
        while (i < this.repoCheckboxes.length) {
            if (this.repoCheckboxes[i].getText().contains("ISCAS")) {
                RuyiProperties.setIscasMirrorChecked(this.repoCheckboxes[i].getSelection());
            } else if (this.repoCheckboxes[i].getText().contains("GitHub")) {
                RuyiProperties.setGithubMirrorChecked(this.repoCheckboxes[i].getSelection());
            } else if (this.repoCheckboxes[i].getText().contains("Custom")) {
                boolean f = this.repoCheckboxes[i].getSelection();
                RuyiProperties.setCustomMirrorChecked(f);
                String text = this.customRepoText.getText();
                RuyiProperties.setCustomMirror(text.trim());
            } else {
                System.out.println("repoCheckboxes text cannot be matched :" + this.repoCheckboxes[i].getText());
            }
            ++i;
        }
    }
}

