/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.ruyisdk.ruyi.core.RuyiCore;
import org.ruyisdk.ruyi.util.RuyiLogger;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.ruyisdk.ruyi";
    private static Activator plugin;
    private RuyiCore ruyiCore;
    private static final RuyiLogger LOGGER;

    static {
        LOGGER = new RuyiLogger(Platform.getLog((Bundle)FrameworkUtil.getBundle(Activator.class)), PLUGIN_ID);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.ruyiCore = new RuyiCore(LOGGER);
        this.ruyiCore.startBackgroundJobs();
        LOGGER.logInfo("Ruyi activated successfully.");
    }

    public void stop(BundleContext context) throws Exception {
        try {
            try {
                if (this.ruyiCore != null) {
                    this.ruyiCore.shutdown();
                }
                this.cleanupResources();
                LOGGER.logInfo("Ruyi plugin deactivated");
            }
            catch (Exception e) {
                LOGGER.logError("Error during plugin deactivation", e);
                plugin = null;
                super.stop(context);
            }
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public RuyiCore getRuyiCore() {
        return this.ruyiCore;
    }

    public static RuyiLogger getLogger() {
        return LOGGER;
    }

    public IPreferenceStore getPreferenceStore() {
        return super.getPreferenceStore();
    }

    private void cleanupResources() {
    }

    public static IStatus createError(String message, Throwable ex) {
        return new Status(4, PLUGIN_ID, message, ex);
    }
}

