/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.projectcreator.properties;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.ruyisdk.packages.JsonParser;

public class BuildPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text buildCommandText;
    private Text ruyiVenvCmdText;
    private static final String BUILD_CMD_PROPERTY = "buildCmd";
    private static final String RUYI_VENV_CMD_PROPERTY = "ruyiVenvCmd";
    private static final String BOARD_MODEL_PROPERTY = "boardModel";

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0).setText("Compile Commands:");
        this.buildCommandText = new Text(composite, 2052);
        this.buildCommandText.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText("Ruyi Venv Command:");
        this.ruyiVenvCmdText = new Text(composite, 2052);
        this.ruyiVenvCmdText.setLayoutData((Object)new GridData(768));
        this.loadProperties();
        return composite;
    }

    private void loadProperties() {
        try {
            IProject project = (IProject)this.getElement().getAdapter(IProject.class);
            String buildCmd = project.getPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", BUILD_CMD_PROPERTY));
            if (buildCmd != null) {
                this.buildCommandText.setText(buildCmd);
            } else {
                this.buildCommandText.setText("make");
            }
            String venvCmd = project.getPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", RUYI_VENV_CMD_PROPERTY));
            if (venvCmd != null && !venvCmd.trim().isEmpty()) {
                this.ruyiVenvCmdText.setText(venvCmd);
            } else {
                this.ruyiVenvCmdText.setText(this.generateDefaultVenvCommand());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean performOk() {
        try {
            IProject project = (IProject)this.getElement().getAdapter(IProject.class);
            project.setPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", BUILD_CMD_PROPERTY), this.buildCommandText.getText().trim());
            project.setPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", RUYI_VENV_CMD_PROPERTY), this.ruyiVenvCmdText.getText().trim());
        }
        catch (CoreException coreException) {
            return false;
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.buildCommandText.setText("make");
        this.ruyiVenvCmdText.setText(this.generateDefaultVenvCommand());
        super.performDefaults();
    }

    private String generateDefaultVenvCommand() {
        try {
            String profile;
            String toolchain;
            IProject project = (IProject)this.getElement().getAdapter(IProject.class);
            String boardModel = project.getPersistentProperty(new QualifiedName("org.ruyisdk.projectcreator", BOARD_MODEL_PROPERTY));
            if (boardModel == null || boardModel.trim().isEmpty()) {
                toolchain = "gnu-plct";
                profile = "generic";
            } else {
                profile = boardModel;
                toolchain = JsonParser.findInstalledToolchainForBoard((String)boardModel);
                if (toolchain == null || toolchain.trim().isEmpty()) {
                    toolchain = "milkv-duo".equals(boardModel) ? "gnu-milkv-milkv-duo-elf-bin" : ("sipeed-lpi4a".equals(boardModel) ? "gnu-plct-xthead" : "gnu-plct");
                } else {
                    int versionIndex = toolchain.indexOf("-0.");
                    if (versionIndex > 0) {
                        toolchain = toolchain.substring(0, versionIndex);
                    }
                }
            }
            String ruyiPath = this.getRuyiInstallPath() + "/ruyi";
            return String.format("%s venv -t %s %s ./%s", ruyiPath, toolchain, profile, "ruyiVenv");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getRuyiInstallPath() {
        try {
            Class<?> clazz = Class.forName("org.ruyisdk.ruyi.util.RuyiFileUtils");
            Method method = clazz.getMethod("getInstallPath", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return System.getProperty("user.home") + "/.ruyi";
        }
    }
}

