/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.intro;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenBrowserHandler
extends AbstractHandler {
    private static final String[][] URL_MAPPINGS = new String[][]{{"blog", "https://ruyisdk.org/blog"}, {"home", "https://ruyisdk.org"}, {"contact", "https://ruyisdk.org/contact"}, {"docs", "https://ruyisdk.org/docs/intro"}, {"matrix", "https://matrix.ruyisdk.org"}, {"discussions", "https://github.com/ruyisdk/ruyisdk/discussions"}};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String command = event.getCommand().getId();
        String target = command.substring(command.lastIndexOf(46) + 1);
        String url = this.findUrl(target);
        if (url == null) {
            System.err.println("No URL mapping found for: " + target);
            return null;
        }
        this.openUrl(url);
        return null;
    }

    private String findUrl(String target) {
        String[][] stringArray = URL_MAPPINGS;
        int n = URL_MAPPINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] mapping = stringArray[n2];
            if (mapping[0].equals(target)) {
                return mapping[1];
            }
            ++n2;
        }
        return null;
    }

    void openUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
            return;
        }
        catch (Exception e) {
            System.err.println("Java Desktop open failed : " + e.getMessage());
            System.out.println("Desktop method failed, falling back to command invocation");
            try {
                String[] cmd = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win") ? new String[]{"cmd", "/c", "start", url} : (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac") ? new String[]{"open", url} : new String[]{"xdg-open", url});
                new ProcessBuilder(cmd).inheritIO().start();
            }
            catch (IOException ex) {
                System.err.println("All methods failed: " + ex.getMessage());
            }
            return;
        }
    }

    private void openBrowserSupportUrl(String url) {
        try {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            browserSupport.getExternalBrowser().openURL(new URL(url));
            System.out.println("Successfully opened: " + url);
        }
        catch (Exception e) {
            System.err.println("Failed to open browser: " + e.getMessage());
        }
    }

    private void openUrlAbsolutely(String url) {
        try {
            String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            if (os.contains("win")) {
                pb.command("cmd", "/c", "start", "msedge", url);
            } else if (os.contains("mac")) {
                pb.command("open", "-a", "Safari", url);
            } else {
                pb.command("sh", "-c", "xdg-open '" + url + "' || sensible-browser '" + url + "'");
            }
            pb.inheritIO().redirectErrorStream(true).start();
        }
        catch (IOException e) {
            System.err.println("System call method failed to open webpage: " + e.getMessage());
        }
    }
}

