/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.intro;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.ruyisdk.intro.Activator;

public class CustomIntroPart
implements IIntroPart {
    private Browser browser;
    private IIntroSite site;
    private List<IPropertyListener> propertyListeners = new ArrayList<IPropertyListener>();
    private String title = "Welcome";

    private String escapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    public void init(IIntroSite site, IMemento memento) throws PartInitException {
        this.site = site;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.browser = new Browser(parent, 0);
        try {
            Bundle bundle;
            Bundle bundle2 = bundle = Activator.getDefault() != null ? Activator.getDefault().getBundle() : FrameworkUtil.getBundle(this.getClass());
            if (bundle == null) {
                this.browser.setText("<html><body><h1>Error: Plugin bundle could not be determined.</h1></body></html>");
                return;
            }
            List<String> resourcePaths = Arrays.asList("html/welcome.html", "html/style.css", "icons/ruyi_logo.png", "icons/icon_new.png", "icons/icon_open.png", "icons/icon_settings.png", "icons/icon_matrix.png", "icons/icon_docs.png", "icons/icon_discussions.png");
            URL resolvedWelcomePageUrl = null;
            for (String resourcePath : resourcePaths) {
                URL bundleUrl = FileLocator.find((Bundle)bundle, (IPath)new Path(resourcePath), null);
                if (bundleUrl != null) {
                    try {
                        URL fileUrl = FileLocator.toFileURL((URL)bundleUrl);
                        if (!resourcePath.equals("html/welcome.html")) continue;
                        resolvedWelcomePageUrl = fileUrl;
                        continue;
                    }
                    catch (IOException ioException) {
                        if (!resourcePath.equals("html/welcome.html")) continue;
                        String errorMessage = ioException.getMessage();
                        String safeErrorMessage = errorMessage == null ? "An unknown error occurred." : this.escapeHtml(errorMessage);
                        String errorHtml = "<html><body><h1>Error: Could not resolve welcome.html to a file URL.</h1><p>" + safeErrorMessage + "</p></body></html>";
                        this.browser.setText(errorHtml);
                        return;
                    }
                }
                if (!resourcePath.equals("html/welcome.html")) continue;
                this.browser.setText("<html><body><h1>Error: welcome.html not found in bundle.</h1></body></html>");
                return;
            }
            if (resolvedWelcomePageUrl != null) {
                this.browser.setUrl(resolvedWelcomePageUrl.toExternalForm());
            } else {
                String errorMsg = "<html><body><h1>Error: Welcome page URL could not be determined after resource processing.</h1></body></html>";
                this.browser.setText(errorMsg);
            }
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            String safeErrorMessage = errorMessage == null ? "An unknown error occurred." : this.escapeHtml(errorMessage);
            this.browser.setText("<html><body><h1>Error loading welcome page.</h1><p>" + safeErrorMessage + "</p></body></html>");
        }
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String url = event.location;
                if (url == null) {
                    event.doit = false;
                    return;
                }
                if (url.startsWith("file:") && url.contains(".cp/")) {
                    event.doit = true;
                    return;
                }
                if ("about:blank".equalsIgnoreCase(url)) {
                    event.doit = true;
                    return;
                }
                if (url.startsWith("http://org.eclipse.ui.intro/execute?command=")) {
                    String commandId = url.substring(url.indexOf("command=") + "command=".length());
                    if (commandId.contains("&")) {
                        commandId = commandId.substring(0, commandId.indexOf("&"));
                    }
                    try {
                        IHandlerService handlerService;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null && (handlerService = (IHandlerService)window.getService(IHandlerService.class)) != null) {
                            handlerService.executeCommand(commandId, null);
                        }
                    }
                    catch (Exception exception) {}
                    event.doit = false;
                } else if (url.startsWith("http:") || url.startsWith("https:")) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
                    }
                    catch (MalformedURLException | PartInitException throwable) {}
                    event.doit = false;
                } else {
                    event.doit = url.startsWith("file:");
                }
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    public void standbyStateChanged(boolean standby) {
    }

    public void setFocus() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.setFocus();
        }
    }

    public void dispose() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.dispose();
        }
        this.propertyListeners.clear();
        this.site = null;
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (!this.propertyListeners.contains(listener)) {
            this.propertyListeners.add(listener);
        }
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.propertyListeners.remove(listener);
    }

    public IIntroSite getIntroSite() {
        return this.site;
    }

    public void saveState(IMemento memento) {
    }

    public String getTitle() {
        return this.title;
    }

    public Image getTitleImage() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IIntroPart.class)) {
            return (T)this;
        }
        return null;
    }
}

