/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.venv.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import org.ruyisdk.venv.Activator;
import org.ruyisdk.venv.model.Venv;
import org.ruyisdk.venv.viewmodel.VenvListViewModel;
import org.ruyisdk.venv.viewmodel.VenvWizardViewModel;
import org.ruyisdk.venv.views.VenvWizard;

public class VenvView
extends ViewPart {
    public static final String ID = "org.ruyisdk.venv.view";
    private VenvListViewModel venvListViewModel;
    private DataBindingContext dbc;
    private Composite container;
    private Composite header;
    private Composite tableComposite;
    private Composite buttonBar;
    private Button absPathCheckBox;
    private TableViewer tableViewer;
    private Button applyButton;
    private Button deleteButton;
    private Button newButton;

    public void createPartControl(Composite parent) {
        Activator activator = Activator.getDefault();
        this.venvListViewModel = new VenvListViewModel(activator.getDetectionService(), activator.getConfigService());
        this.createLayouts(parent);
        this.addControls();
        this.registerEvents();
        this.venvListViewModel.onRefreshVenvListAsync();
    }

    private void createLayouts(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.header = new Composite(this.container, 0);
        this.header.setLayoutData((Object)new GridData(768));
        this.header.setLayout((Layout)new GridLayout(2, false));
        this.tableComposite = new Composite(this.container, 0);
        this.tableComposite.setLayoutData((Object)new GridData(1808));
        this.buttonBar = new Composite(this.container, 0);
        this.buttonBar.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        this.buttonBar.setLayout((Layout)gridLayout);
    }

    private void addControls() {
        Label headerLabel = new Label(this.header, 0);
        headerLabel.setLayoutData((Object)new GridData(768));
        headerLabel.setText("Detected virtual environments in open projects:");
        this.absPathCheckBox = new Button(this.header, 32);
        this.absPathCheckBox.setText("Show absolute path");
        this.absPathCheckBox.setEnabled(false);
        this.absPathCheckBox.setSelection(true);
        this.tableViewer = new TableViewer(this.tableComposite, 67586);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 16384);
        column.getColumn().setText("Profile");
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(15, 120));
        column = new TableViewerColumn(this.tableViewer, 16384);
        column.getColumn().setText("Toolchain Prefix");
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 180));
        column = new TableViewerColumn(this.tableViewer, 16384);
        column.getColumn().setText("Sysroot");
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 250));
        column = new TableViewerColumn(this.tableViewer, 16384);
        column.getColumn().setText("Project Path");
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(35, 300));
        this.tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])BeanProperties.values(Venv.class, (String[])new String[]{"profile", "toolchainPrefix", "sysroot", "projectPath"}))));
        this.tableViewer.setInput(this.venvListViewModel.getVenvList());
        this.applyButton = new Button(this.buttonBar, 8);
        this.applyButton.setText("Apply to Project");
        this.applyButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.deleteButton = new Button(this.buttonBar, 8);
        this.deleteButton.setText("Delete...");
        this.deleteButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.newButton = new Button(this.buttonBar, 8);
        this.newButton.setText("New virtual environment...");
        this.newButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
    }

    private void registerEvents() {
        this.dbc = new DataBindingContext();
        this.dbc.bindList((IObservableList)ViewerProperties.multipleSelection().observe((Viewer)this.tableViewer), this.venvListViewModel.getSelectedVenvs());
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.deleteButton), BeanProperties.value(VenvListViewModel.class, (String)"canDelete", Boolean.class).observe((Object)this.venvListViewModel));
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.applyButton), BeanProperties.value(VenvListViewModel.class, (String)"canApply", Boolean.class).observe((Object)this.venvListViewModel));
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VenvView.this.venvListViewModel.onApplySelectedVenvConfig(result -> VenvView.this.container.getDisplay().asyncExec(() -> MessageDialog.openInformation((Shell)VenvView.this.container.getShell(), (String)"Apply Configuration", (String)result.getMessage())));
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<String> venvPaths = VenvView.this.venvListViewModel.getSelectedVenvDirectoryPaths();
                if (venvPaths.isEmpty()) {
                    return;
                }
                String message = venvPaths.size() == 1 ? "This will delete the whole directory of the virtual environment:\n\n" + venvPaths.get(0) + "\n\nContinue?" : "This will delete the whole directories of the selected virtual environments:\n\n" + String.join((CharSequence)"\n", venvPaths) + "\n\nContinue?";
                boolean confirmDeletion = MessageDialog.openConfirm((Shell)VenvView.this.container.getShell(), (String)"Delete virtual environment", (String)message);
                if (!confirmDeletion) {
                    return;
                }
                VenvView.this.venvListViewModel.onDeleteSelectedVenvDirectories(err -> {
                    if (err != null) {
                        MessageDialog.openError((Shell)VenvView.this.container.getShell(), (String)"Delete virtual environment failed", (String)("Failed to delete:\n\n" + err.getMessage()));
                    }
                });
            }
        });
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VenvWizardViewModel wizardViewModel = new VenvWizardViewModel(Activator.getDefault().getDetectionService());
                wizardViewModel.setProjectRootPaths(VenvView.getOpenProjectRootPaths());
                WizardDialog dialog = new WizardDialog(VenvView.this.container.getShell(), (IWizard)new VenvWizard(wizardViewModel));
                if (dialog.open() == 0) {
                    VenvView.this.venvListViewModel.onRefreshVenvListAsync();
                }
            }
        });
    }

    public void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
        super.dispose();
    }

    public void setFocus() {
    }

    private static List<String> getOpenProjectRootPaths() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ArrayList<String> result = new ArrayList<String>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IPath location;
            IProject project = iProjectArray[n2];
            if (project != null && project.isOpen() && (location = project.getLocation()) != null) {
                result.add(location.toOSString());
            }
            ++n2;
        }
        Collections.sort(result);
        return result;
    }
}

