/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.venv.viewmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.ruyisdk.ruyi.services.RuyiCli;
import org.ruyisdk.venv.model.Emulator;
import org.ruyisdk.venv.model.Profile;
import org.ruyisdk.venv.model.Toolchain;
import org.ruyisdk.venv.model.VenvDetectionService;

public class VenvWizardViewModel {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final VenvDetectionService service;
    private boolean configurationPageComplete;
    private String summaryText = "";
    private final List<Profile> profiles = new ArrayList<Profile>();
    private int selectedProfileIndex = -1;
    private final List<Toolchain> toolchains = new ArrayList<Toolchain>();
    private int selectedToolchainIndex = -1;
    private int selectedToolchainVersionIndex = -1;
    private final List<Emulator> emulators = new ArrayList<Emulator>();
    private int selectedEmulatorIndex = -1;
    private int selectedEmulatorVersionIndex = -1;
    private boolean emulatorEnabled = false;
    private SysrootOption sysrootOption = SysrootOption.DEFAULT_SYSROOT;
    private String venvLocation = "";
    private String venvName = "";
    private final IObservableList<String> projectRootPaths = new WritableList(new ArrayList(), String.class);

    public VenvWizardViewModel(VenvDetectionService service) {
        this.service = service;
        this.refreshListsBestEffort();
        this.recomputeDerivedState();
    }

    private void recomputeDerivedState() {
        this.updateSummaryText();
        this.recomputeConfigurationPageComplete();
    }

    private void updateSummaryText() {
        String old = this.summaryText;
        this.summaryText = this.buildSummaryText();
        this.pcs.firePropertyChange("summaryText", old, this.summaryText);
    }

    private void recomputeConfigurationPageComplete() {
        boolean old = this.configurationPageComplete;
        this.configurationPageComplete = this.computeConfigurationPageComplete();
        this.pcs.firePropertyChange("configurationPageComplete", old, this.configurationPageComplete);
    }

    private boolean computeConfigurationPageComplete() {
        if (this.selectedProfileIndex < 0 || this.selectedProfileIndex >= this.profiles.size()) {
            return false;
        }
        if (this.selectedToolchainIndex < 0 || this.selectedToolchainIndex >= this.toolchains.size()) {
            return false;
        }
        List<String> toolchainVersions = this.toolchains.get(this.selectedToolchainIndex).getVersions();
        if (toolchainVersions == null || this.selectedToolchainVersionIndex < 0 || this.selectedToolchainVersionIndex >= toolchainVersions.size()) {
            return false;
        }
        if (!this.emulatorEnabled) {
            return true;
        }
        if (this.selectedEmulatorIndex < 0 || this.selectedEmulatorIndex >= this.emulators.size()) {
            return false;
        }
        List<String> emulatorVersions = this.emulators.get(this.selectedEmulatorIndex).getVersions();
        return emulatorVersions != null && this.selectedEmulatorVersionIndex >= 0 && this.selectedEmulatorVersionIndex < emulatorVersions.size();
    }

    private String buildSummaryText() {
        List<String> versions;
        StringBuilder sb = new StringBuilder();
        sb.append("Profile: ");
        if (this.selectedProfileIndex >= 0 && this.selectedProfileIndex < this.profiles.size()) {
            Profile profile = this.profiles.get(this.selectedProfileIndex);
            sb.append(profile.getName());
            String quirks = profile.getQuirks();
            if (quirks != null && !quirks.isEmpty()) {
                sb.append(" (quirks: ").append(quirks).append(")");
            }
        }
        sb.append('\n');
        sb.append("Toolchain: ");
        if (this.selectedToolchainIndex >= 0 && this.selectedToolchainIndex < this.toolchains.size()) {
            Toolchain toolchain = this.toolchains.get(this.selectedToolchainIndex);
            sb.append(toolchain.getName());
            versions = toolchain.getVersions();
            if (this.selectedToolchainVersionIndex >= 0 && versions != null && this.selectedToolchainVersionIndex < versions.size()) {
                sb.append(" (").append(versions.get(this.selectedToolchainVersionIndex)).append(")");
            }
        }
        sb.append('\n');
        sb.append("Emulator: ");
        if (!this.emulatorEnabled) {
            sb.append("disabled");
        } else if (this.selectedEmulatorIndex >= 0 && this.selectedEmulatorIndex < this.emulators.size()) {
            Emulator emulator = this.emulators.get(this.selectedEmulatorIndex);
            sb.append(emulator.getName());
            versions = emulator.getVersions();
            if (this.selectedEmulatorVersionIndex >= 0 && versions != null && this.selectedEmulatorVersionIndex < versions.size()) {
                sb.append(" (").append(versions.get(this.selectedEmulatorVersionIndex)).append(")");
            }
        }
        sb.append('\n');
        sb.append("Sysroot: ").append(this.sysrootOption.toString());
        return sb.toString();
    }

    private void refreshListsBestEffort() {
        try {
            List<RuyiCli.EmulatorInfo> emulatorInfos;
            List<RuyiCli.ToolchainInfo> toolchainInfos;
            this.profiles.clear();
            this.toolchains.clear();
            this.emulators.clear();
            List<RuyiCli.ProfileInfo> profileInfos = this.service.listProfiles();
            if (profileInfos != null) {
                for (RuyiCli.ProfileInfo profileInfo : profileInfos) {
                    this.profiles.add(new Profile(profileInfo.getName(), profileInfo.getQuirks()));
                }
            }
            if ((toolchainInfos = this.service.listToolchains()) != null) {
                for (RuyiCli.ToolchainInfo toolchainInfo : toolchainInfos) {
                    this.toolchains.add(new Toolchain(toolchainInfo.getName(), toolchainInfo.getVersions()));
                }
            }
            if ((emulatorInfos = this.service.listEmulators()) != null) {
                for (RuyiCli.EmulatorInfo emulatorInfo : emulatorInfos) {
                    this.emulators.add(new Emulator(emulatorInfo.getName(), emulatorInfo.getVersions()));
                }
            }
        }
        catch (Exception exception) {}
    }

    public RuyiCli.RunResult updateIndex() {
        RuyiCli.RunResult result = this.service.updateIndex();
        this.refreshListsBestEffort();
        this.recomputeDerivedState();
        this.pcs.firePropertyChange("dataRefreshed", null, Boolean.TRUE);
        return result;
    }

    private RuyiCli.RunResult installToolchain(String name, String version) {
        return this.service.installPackage(name, version);
    }

    public RuyiCli.RunResult installToolchain() {
        if (this.selectedToolchainIndex < 0 || this.selectedToolchainIndex >= this.toolchains.size() || this.selectedToolchainVersionIndex < 0) {
            return new RuyiCli.RunResult(-1, "No toolchain selected");
        }
        String name = this.toolchains.get(this.selectedToolchainIndex).getName();
        String version = this.toolchains.get(this.selectedToolchainIndex).getVersions().get(this.selectedToolchainVersionIndex);
        return this.installToolchain(name, version);
    }

    private RuyiCli.RunResult installEmulator(String name, String version) {
        return this.service.installPackage(name, version);
    }

    public RuyiCli.RunResult installEmulator() {
        if (!this.emulatorEnabled) {
            return new RuyiCli.RunResult(0, "Emulator disabled");
        }
        if (this.selectedEmulatorIndex < 0 || this.selectedEmulatorIndex >= this.emulators.size() || this.selectedEmulatorVersionIndex < 0) {
            return new RuyiCli.RunResult(-1, "Emulator enabled but not selected");
        }
        String name = this.emulators.get(this.selectedEmulatorIndex).getName();
        String version = this.emulators.get(this.selectedEmulatorIndex).getVersions().get(this.selectedEmulatorVersionIndex);
        return this.installEmulator(name, version);
    }

    private RuyiCli.RunResult createVenv(String path, String toolchainName, String toolchainVersion, String profile, String emulatorName, String emulatorVersion) {
        return this.service.createVenv(path, toolchainName, toolchainVersion, profile, emulatorName, emulatorVersion);
    }

    public RuyiCli.RunResult createVenv() {
        String parent = this.venvLocation;
        if (parent == null || parent.isBlank()) {
            return new RuyiCli.RunResult(-1, "Venv parent path is empty");
        }
        String name = this.venvName;
        if (name == null || name.isBlank()) {
            return new RuyiCli.RunResult(-1, "Venv name is empty");
        }
        if (this.selectedToolchainIndex < 0 || this.selectedToolchainIndex >= this.toolchains.size() || this.selectedToolchainVersionIndex < 0) {
            return new RuyiCli.RunResult(-1, "No toolchain selected");
        }
        String toolchainName = this.toolchains.get(this.selectedToolchainIndex).getName();
        String toolchainVersion = this.toolchains.get(this.selectedToolchainIndex).getVersions().get(this.selectedToolchainVersionIndex);
        String profile = null;
        if (this.selectedProfileIndex >= 0 && this.selectedProfileIndex < this.profiles.size()) {
            profile = this.profiles.get(this.selectedProfileIndex).getName();
        }
        String emulatorName = null;
        String emulatorVersion = null;
        if (this.emulatorEnabled) {
            if (this.selectedEmulatorIndex < 0 || this.selectedEmulatorIndex >= this.emulators.size() || this.selectedEmulatorVersionIndex < 0) {
                return new RuyiCli.RunResult(-1, "Emulator enabled but not selected");
            }
            emulatorName = this.emulators.get(this.selectedEmulatorIndex).getName();
            emulatorVersion = this.emulators.get(this.selectedEmulatorIndex).getVersions().get(this.selectedEmulatorVersionIndex);
        }
        File target = new File(parent, name);
        String path = target.getPath();
        return this.createVenv(path, toolchainName, toolchainVersion, profile, emulatorName, emulatorVersion);
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public int getSelectedProfileIndex() {
        return this.selectedProfileIndex;
    }

    public void setSelectedProfileIndex(int index) {
        int old = this.selectedProfileIndex;
        this.selectedProfileIndex = index;
        this.pcs.firePropertyChange("selectedProfileIndex", old, this.selectedProfileIndex);
        this.recomputeDerivedState();
    }

    public List<Toolchain> getToolchains() {
        return this.toolchains;
    }

    public int getSelectedToolchainIndex() {
        return this.selectedToolchainIndex;
    }

    public void setSelectedToolchainIndex(int index) {
        int old = this.selectedToolchainIndex;
        this.selectedToolchainIndex = index;
        this.pcs.firePropertyChange("selectedToolchainIndex", old, this.selectedToolchainIndex);
        if (old != index) {
            this.setSelectedToolchainVersionIndex(-1);
        }
        this.recomputeDerivedState();
    }

    public int getSelectedToolchainVersionIndex() {
        return this.selectedToolchainVersionIndex;
    }

    public void setSelectedToolchainVersionIndex(int index) {
        int old = this.selectedToolchainVersionIndex;
        this.selectedToolchainVersionIndex = index;
        this.pcs.firePropertyChange("selectedToolchainVersionIndex", old, this.selectedToolchainVersionIndex);
        this.recomputeDerivedState();
    }

    public List<Emulator> getEmulators() {
        return this.emulators;
    }

    public int getSelectedEmulatorIndex() {
        return this.selectedEmulatorIndex;
    }

    public void setSelectedEmulatorIndex(int index) {
        int old = this.selectedEmulatorIndex;
        this.selectedEmulatorIndex = index;
        this.pcs.firePropertyChange("selectedEmulatorIndex", old, this.selectedEmulatorIndex);
        if (old != index) {
            this.setSelectedEmulatorVersionIndex(-1);
        }
        this.recomputeDerivedState();
    }

    public int getSelectedEmulatorVersionIndex() {
        return this.selectedEmulatorVersionIndex;
    }

    public void setSelectedEmulatorVersionIndex(int index) {
        int old = this.selectedEmulatorVersionIndex;
        this.selectedEmulatorVersionIndex = index;
        this.pcs.firePropertyChange("selectedEmulatorVersionIndex", old, this.selectedEmulatorVersionIndex);
        this.recomputeDerivedState();
    }

    public boolean isEmulatorEnabled() {
        return this.emulatorEnabled;
    }

    public void setEmulatorEnabled(boolean enabled) {
        boolean old = this.emulatorEnabled;
        this.emulatorEnabled = enabled;
        this.pcs.firePropertyChange("emulatorEnabled", old, this.emulatorEnabled);
        if (!enabled) {
            this.setSelectedEmulatorIndex(-1);
            this.setSelectedEmulatorVersionIndex(-1);
        }
        this.recomputeDerivedState();
    }

    public SysrootOption getSysrootOption() {
        return this.sysrootOption;
    }

    public void setSysrootOption(SysrootOption option) {
        SysrootOption old = this.sysrootOption;
        this.sysrootOption = option;
        this.pcs.firePropertyChange("sysrootOption", (Object)old, (Object)this.sysrootOption);
        this.recomputeDerivedState();
    }

    public String getVenvLocation() {
        return this.venvLocation;
    }

    public void setVenvLocation(String location) {
        String old = this.venvLocation;
        this.venvLocation = location == null ? "" : location;
        this.pcs.firePropertyChange("venvLocation", old, this.venvLocation);
    }

    public IObservableList<String> getProjectRootPaths() {
        return this.projectRootPaths;
    }

    public void setProjectRootPaths(Collection<String> paths) {
        Runnable update = () -> {
            this.projectRootPaths.clear();
            if (paths != null) {
                for (String path : paths) {
                    if (path == null || path.isBlank()) continue;
                    this.projectRootPaths.add((Object)path);
                }
            }
        };
        if (this.projectRootPaths.getRealm().isCurrent()) {
            update.run();
        } else {
            this.projectRootPaths.getRealm().asyncExec(update);
        }
    }

    public String getVenvName() {
        return this.venvName;
    }

    public void setVenvName(String name) {
        String old = this.venvName;
        this.venvName = name == null ? "" : name;
        this.pcs.firePropertyChange("venvName", old, this.venvName);
    }

    public String getSummaryText() {
        return this.summaryText;
    }

    public boolean isConfigurationPageComplete() {
        return this.configurationPageComplete;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static enum SysrootOption {
        NONE_SYSROOT,
        DEFAULT_SYSROOT,
        FOREIGN_TOOLCHAIN;

    }
}

