/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.venv.viewmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.ruyisdk.ruyi.util.RuyiLogger;
import org.ruyisdk.venv.Activator;
import org.ruyisdk.venv.model.Venv;
import org.ruyisdk.venv.model.VenvConfigurationService;
import org.ruyisdk.venv.model.VenvDetectionService;

public class VenvListViewModel {
    private static final RuyiLogger LOGGER = Activator.getLogger();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean isFetching = false;
    private boolean canDelete = false;
    private boolean canApply = false;
    private final VenvDetectionService detectionService;
    private final VenvConfigurationService configService;
    private final IObservableList<Venv> observableVenvList = new WritableList(new ArrayList(), Venv.class);
    private final IObservableList<Venv> selectedVenvs = new WritableList(new ArrayList(), Venv.class);

    public VenvListViewModel(VenvDetectionService detectionService, VenvConfigurationService configService) {
        this.detectionService = detectionService;
        this.configService = configService;
        this.selectedVenvs.addListChangeListener(event -> {
            this.updateCanDelete();
            this.updateCanApply();
        });
    }

    public IObservableList<Venv> getVenvList() {
        return this.observableVenvList;
    }

    public IObservableList<Venv> getSelectedVenvs() {
        return this.selectedVenvs;
    }

    public boolean isCanDelete() {
        return this.canDelete;
    }

    private void setCanDelete(boolean canDelete) {
        if (this.canDelete == canDelete) {
            return;
        }
        this.canDelete = canDelete;
        this.pcs.firePropertyChange("canDelete", this.canDelete, this.canDelete);
    }

    public boolean isCanApply() {
        return this.canApply;
    }

    private void setCanApply(boolean canApply) {
        if (this.canApply == canApply) {
            return;
        }
        this.canApply = canApply;
        this.pcs.firePropertyChange("canApply", this.canApply, this.canApply);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void setFetching(boolean isFetching) {
        this.isFetching = isFetching;
        this.updateCanDelete();
        this.updateCanApply();
    }

    private void updateCanDelete() {
        this.setCanDelete(!this.isFetching && !this.getSelectedVenvDirectoryPaths().isEmpty());
    }

    private void updateCanApply() {
        if (this.isFetching || this.selectedVenvs.size() != 1) {
            this.setCanApply(false);
            return;
        }
        Venv selected = (Venv)this.selectedVenvs.get(0);
        String projectPath = selected.getProjectPath();
        this.setCanApply(projectPath != null && !projectPath.isEmpty());
    }

    public void onRefreshVenvListAsync() {
        if (this.isFetching) {
            return;
        }
        LOGGER.logInfo("Refreshing venv list");
        this.setFetching(true);
        this.detectionService.detectProjectVenvsAsync(result -> this.observableVenvList.getRealm().asyncExec(() -> {
            this.observableVenvList.clear();
            this.observableVenvList.addAll((Collection)result);
            LOGGER.logInfo("Venv list refreshed; count=" + result.size());
            this.setFetching(false);
        }));
    }

    public List<String> getSelectedVenvDirectoryPaths() {
        return this.detectionService.getVenvDirectoryPathsFromVenvs(new ArrayList<Venv>((Collection<Venv>)this.selectedVenvs));
    }

    public void onDeleteSelectedVenvDirectories(Consumer<Exception> callback) {
        if (this.isFetching) {
            return;
        }
        List<String> venvPaths = this.getSelectedVenvDirectoryPaths();
        if (venvPaths.isEmpty()) {
            if (callback != null) {
                callback.accept(null);
            }
            return;
        }
        LOGGER.logInfo("Deleting selected venv directories: count=" + venvPaths.size());
        this.setFetching(true);
        this.detectionService.deleteVenvDirectoriesAsync(venvPaths, err -> this.observableVenvList.getRealm().asyncExec(() -> {
            this.setFetching(false);
            if (err == null) {
                this.onRefreshVenvListAsync();
            }
            if (callback != null) {
                callback.accept((Exception)err);
            }
        }));
    }

    public void onApplySelectedVenvConfig(Consumer<VenvConfigurationService.ApplyResult> callback) {
        if (this.isFetching) {
            if (callback != null) {
                callback.accept(new VenvConfigurationService.ApplyResult(false, "Operation in progress"));
            }
            return;
        }
        if (this.selectedVenvs.size() != 1) {
            if (callback != null) {
                callback.accept(new VenvConfigurationService.ApplyResult(false, "No venv selected"));
            }
            return;
        }
        Venv selected = (Venv)this.selectedVenvs.get(0);
        LOGGER.logInfo("Applying venv configuration to project: venv=" + selected.getPath());
        this.setFetching(true);
        this.configService.applyToProjectAsync(selected, result -> this.observableVenvList.getRealm().asyncExec(() -> {
            this.setFetching(false);
            if (result.isSuccess()) {
                LOGGER.logInfo("Venv configuration applied successfully");
            } else {
                LOGGER.logWarning("Venv configuration failed: " + result.getMessage(), null);
            }
            if (callback != null) {
                callback.accept((VenvConfigurationService.ApplyResult)result);
            }
        }));
    }
}

