/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.venv.model;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.ruyisdk.ruyi.services.RuyiCli;
import org.ruyisdk.ruyi.util.RuyiLogger;
import org.ruyisdk.venv.Activator;
import org.ruyisdk.venv.model.Venv;

public class VenvDetectionService {
    private static final String VENV_CONFIG_FILE_NAME = "ruyi-venv.toml";
    private static final RuyiLogger LOGGER = Activator.getLogger();

    private static List<Path> getOpenProjectPaths() {
        ArrayList<Path> out = new ArrayList<Path>();
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] iProjectArray = root.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath loc;
                IProject project = iProjectArray[n2];
                if (project != null && project.isOpen() && (loc = project.getLocation()) != null) {
                    out.add(Path.of(loc.toOSString(), new String[0]));
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        out.removeIf(Objects::isNull);
        return out;
    }

    public List<String> getVenvDirectoryPathsFromVenvs(List<Venv> venvs) {
        if (venvs == null || venvs.isEmpty()) {
            return List.of();
        }
        LinkedHashSet<String> out = new LinkedHashSet<String>();
        for (Venv venv : venvs) {
            String p;
            if (venv == null || (p = venv.getPath()) == null || p.isBlank()) continue;
            out.add(p);
        }
        return List.copyOf(out);
    }

    private static List<Path> toPathList(List<String> pathStrings) {
        if (pathStrings == null || pathStrings.isEmpty()) {
            return List.of();
        }
        ArrayList<Path> out = new ArrayList<Path>();
        for (String p : pathStrings) {
            if (p == null || p.isBlank()) continue;
            out.add(Path.of(p, new String[0]));
        }
        out.removeIf(Objects::isNull);
        return out;
    }

    public List<RuyiCli.ProfileInfo> listProfiles() {
        try {
            return RuyiCli.listProfiles();
        }
        catch (Exception e) {
            LOGGER.logError("Failed to list profiles", (Throwable)e);
            return new ArrayList<RuyiCli.ProfileInfo>();
        }
    }

    public List<RuyiCli.ToolchainInfo> listToolchains() {
        try {
            return RuyiCli.listToolchains();
        }
        catch (Exception e) {
            LOGGER.logError("Failed to list toolchains", (Throwable)e);
            return new ArrayList<RuyiCli.ToolchainInfo>();
        }
    }

    public List<RuyiCli.EmulatorInfo> listEmulators() {
        try {
            return RuyiCli.listEmulators();
        }
        catch (Exception e) {
            LOGGER.logError("Failed to list emulators", (Throwable)e);
            return new ArrayList<RuyiCli.EmulatorInfo>();
        }
    }

    private List<RuyiCli.VenvInfo> listVenvs() {
        try {
            return RuyiCli.listVenvs();
        }
        catch (Exception e) {
            LOGGER.logError("Failed to list virtual environments", (Throwable)e);
            return new ArrayList<RuyiCli.VenvInfo>();
        }
    }

    public RuyiCli.RunResult updateIndex() {
        LOGGER.logInfo("Updating Ruyi package index");
        try {
            RuyiCli.RunResult result = RuyiCli.update();
            if (result != null) {
                LOGGER.logInfo("Ruyi package index update finished: exit=" + result.getExitCode());
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.logError("Failed to update Ruyi package index", (Throwable)e);
            throw e;
        }
    }

    public RuyiCli.RunResult installPackage(String name, String version) {
        LOGGER.logInfo("Installing package: name=" + name + ", version=" + version);
        try {
            RuyiCli.RunResult result = RuyiCli.installPackage((String)name, (String)version);
            if (result != null) {
                LOGGER.logInfo("Package install finished: name=" + name + ", version=" + version + ", exit=" + result.getExitCode());
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.logError("Failed to install package: name=" + name + ", version=" + version, (Throwable)e);
            throw e;
        }
    }

    public RuyiCli.RunResult createVenv(String path, String toolchainName, String toolchainVersion, String profile, String emulatorName, String emulatorVersion) {
        LOGGER.logInfo("Creating venv: path=" + path + ", profile=" + profile + ", toolchain=" + toolchainName + ":" + toolchainVersion + ", emulator=" + emulatorName + ":" + emulatorVersion);
        try {
            RuyiCli.RunResult result = RuyiCli.createVenv((String)path, (String)toolchainName, (String)toolchainVersion, (String)profile, (String)emulatorName, (String)emulatorVersion);
            if (result != null) {
                LOGGER.logInfo("Venv creation finished: path=" + path + ", exit=" + result.getExitCode());
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.logError("Failed to create venv: path=" + path, (Throwable)e);
            throw e;
        }
    }

    private List<Venv> fetchVenvs() {
        List<RuyiCli.ProfileInfo> profileInfos = this.listProfiles();
        HashMap<String, String> profileQuirks = new HashMap<String, String>();
        for (RuyiCli.ProfileInfo profileInfo : profileInfos) {
            profileQuirks.put(profileInfo.getName(), profileInfo.getQuirks());
        }
        List<RuyiCli.VenvInfo> venvInfos = this.listVenvs();
        ArrayList<Venv> out = new ArrayList<Venv>();
        for (RuyiCli.VenvInfo venvInfo : venvInfos) {
            String quirks = profileQuirks.getOrDefault(venvInfo.getProfile(), "");
            out.add(Venv.createStandalone(venvInfo.getPath(), venvInfo.getProfile(), venvInfo.getSysroot(), quirks));
        }
        LOGGER.logInfo("Fetched venv list: count=" + out.size());
        return out;
    }

    public void fetchVenvsAsync(final Consumer<List<Venv>> callback) {
        Job fetchJob = new Job("Fetching virtual environments"){

            protected IStatus run(IProgressMonitor monitor) {
                List<Venv> result;
                LOGGER.logInfo("Fetching venv list (async)");
                try {
                    result = VenvDetectionService.this.fetchVenvs();
                }
                catch (Exception e) {
                    LOGGER.logError("Failed to fetch venv list", (Throwable)e);
                    result = new ArrayList<Venv>();
                }
                LOGGER.logInfo("Venv list fetch completed: count=" + result.size());
                callback.accept(result);
                return Status.OK_STATUS;
            }
        };
        fetchJob.schedule();
    }

    private static List<Venv> detectProjectVenvs(List<Path> projectPaths) {
        if (projectPaths == null || projectPaths.isEmpty()) {
            return List.of();
        }
        LOGGER.logInfo("Detecting project venvs: openProjects=" + projectPaths.size());
        ArrayList<Venv> out = new ArrayList<Venv>();
        for (Path projectPath : projectPaths) {
            if (projectPath == null || !Files.isDirectory(projectPath, new LinkOption[0])) continue;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Stream<Path> children = Files.list(projectPath);){
                    children.filter(Objects::nonNull).filter(path -> Files.isDirectory(path, new LinkOption[0])).forEach(childDir -> {
                        Path toml = childDir.resolve(VENV_CONFIG_FILE_NAME);
                        if (!Files.isRegularFile(toml, new LinkOption[0])) {
                            return;
                        }
                        DetectedVenvConfig cfg = VenvDetectionService.parseVenvConfigBestEffort(toml);
                        Venv venv = Venv.createForProject(childDir.toString(), cfg.profile, cfg.sysroot, projectPath.toString());
                        DerivedToolchainInfo toolchainInfo = VenvDetectionService.deriveToolchainInfo(childDir);
                        venv.setToolchainPath(toolchainInfo.binPath);
                        venv.setToolchainPrefix(toolchainInfo.prefix);
                        out.add(venv);
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.logError("Failed to scan project for venv config: path=" + String.valueOf(projectPath), (Throwable)e);
            }
        }
        LOGGER.logInfo("Project venv detection completed: count=" + out.size());
        return out;
    }

    public void detectProjectVenvsAsync(final Consumer<List<Venv>> callback) {
        Job detectJob = new Job("Detecting virtual environments"){

            protected IStatus run(IProgressMonitor monitor) {
                List<Venv> result;
                LOGGER.logInfo("Detecting project venvs (async)");
                try {
                    List<Path> projectPaths = VenvDetectionService.getOpenProjectPaths();
                    result = VenvDetectionService.detectProjectVenvs(projectPaths);
                }
                catch (Exception e) {
                    LOGGER.logError("Failed to detect project venvs", (Throwable)e);
                    result = List.of();
                }
                LOGGER.logInfo("Project venv detection finished: count=" + result.size());
                callback.accept(result);
                return Status.OK_STATUS;
            }
        };
        detectJob.schedule();
    }

    public void deleteVenvDirectoriesAsync(final List<String> venvDirectoryPaths, final Consumer<Exception> callback) {
        Job deleteJob = new Job("Deleting virtual environments"){

            protected IStatus run(IProgressMonitor monitor) {
                LOGGER.logInfo("Deleting venv directories: count=" + (venvDirectoryPaths == null ? 0 : venvDirectoryPaths.size()));
                try {
                    List<Path> venvDirectories = VenvDetectionService.toPathList(venvDirectoryPaths);
                    if (venvDirectories != null) {
                        for (Path dir : venvDirectories) {
                            LOGGER.logInfo("Deleting venv directory: path=" + String.valueOf(dir));
                            VenvDetectionService.deleteDirectoryRecursively(dir);
                        }
                    }
                    if (callback != null) {
                        callback.accept(null);
                    }
                    LOGGER.logInfo("Venv directory deletion finished");
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    LOGGER.logError("Failed to delete venv directories", (Throwable)e);
                    if (callback != null) {
                        callback.accept(e);
                    }
                    return new Status(4, "org.ruyisdk.venv", "Failed to delete virtual environment", (Throwable)e);
                }
            }
        };
        deleteJob.schedule();
    }

    private static DerivedToolchainInfo deriveToolchainInfo(Path venvPath) {
        if (venvPath == null) {
            return new DerivedToolchainInfo("", "");
        }
        Path binDir = venvPath.resolve("bin");
        if (!Files.isDirectory(binDir, new LinkOption[0])) {
            return new DerivedToolchainInfo("", "");
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<Path> entries = Files.list(binDir);){
                for (Path entry : entries::iterator) {
                    String name;
                    Path fileName;
                    if (entry == null || (fileName = entry.getFileName()) == null || !(name = fileName.toString()).endsWith("-gcc") || !Files.isRegularFile(entry, new LinkOption[0])) continue;
                    String prefix = name.substring(0, name.length() - "-gcc".length());
                    return new DerivedToolchainInfo(binDir.toString(), prefix);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return new DerivedToolchainInfo(binDir.toString(), "");
    }

    private static DetectedVenvConfig parseVenvConfigBestEffort(Path tomlPath) {
        String profile = "";
        String sysroot = "";
        boolean inConfig = false;
        try {
            for (String rawLine : Files.readAllLines(tomlPath, StandardCharsets.UTF_8)) {
                int eq;
                int commentIdx;
                String line;
                String string = line = rawLine == null ? "" : rawLine.trim();
                if (line.isEmpty() || (commentIdx = line.indexOf(35)) >= 0 && (line = line.substring(0, commentIdx).trim()).isEmpty()) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    inConfig = "[config]".equals(line);
                    continue;
                }
                if (!inConfig || (eq = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, eq).trim();
                String val = line.substring(eq + 1).trim();
                val = VenvDetectionService.unquote(val);
                if ("profile".equals(key)) {
                    profile = val;
                    continue;
                }
                if (!"sysroot".equals(key)) continue;
                sysroot = val;
            }
        }
        catch (Exception e) {
            LOGGER.logWarning("Failed to parse venv config: path=" + String.valueOf(tomlPath), (Throwable)e);
        }
        return new DetectedVenvConfig(profile, sysroot);
    }

    private static String unquote(String val) {
        if (val == null) {
            return "";
        }
        String s = val.trim();
        if (s.length() >= 2) {
            char first = s.charAt(0);
            char last = s.charAt(s.length() - 1);
            if (first == '\"' && last == '\"' || first == '\'' && last == '\'') {
                return s.substring(1, s.length() - 1);
            }
        }
        return s;
    }

    private static void deleteDirectoryRecursively(Path dir) throws IOException {
        if (dir == null) {
            return;
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path directory, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.deleteIfExists(directory);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static final class DerivedToolchainInfo {
        private final String binPath;
        private final String prefix;

        private DerivedToolchainInfo(String binPath, String prefix) {
            this.binPath = binPath == null ? "" : binPath;
            this.prefix = prefix == null ? "" : prefix;
        }
    }

    private static final class DetectedVenvConfig {
        private final String profile;
        private final String sysroot;

        private DetectedVenvConfig(String profile, String sysroot) {
            this.profile = profile == null ? "" : profile;
            this.sysroot = sysroot == null ? "" : sysroot;
        }
    }
}

