/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.venv.model;

import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.ruyisdk.ruyi.util.RuyiLogger;
import org.ruyisdk.venv.model.Venv;

public class VenvConfigurationService {
    private static final String PLUGIN_ID = "org.ruyisdk.venv";
    private static final RuyiLogger LOGGER = new RuyiLogger(Platform.getLog((Bundle)FrameworkUtil.getBundle(VenvConfigurationService.class)), "org.ruyisdk.venv");
    private static final String ENV_RUYI_VENV = "RUYI_VENV";

    private ApplyResult applyToProject(Venv venv) {
        if (venv == null) {
            LOGGER.logWarning("applyToProject called with null venv", null);
            return new ApplyResult(false, "Venv is null");
        }
        LOGGER.logInfo("Applying venv configuration: venv=" + venv.getPath() + ", project=" + venv.getProjectPath());
        String projectPath = venv.getProjectPath();
        if (projectPath == null || projectPath.isBlank()) {
            return new ApplyResult(false, "Venv has no associated project path");
        }
        IProject project = this.findProjectByPath(projectPath);
        if (project == null) {
            return new ApplyResult(false, "Could not find project at: " + projectPath);
        }
        if (!project.isOpen()) {
            return new ApplyResult(false, "Project is not open: " + project.getName());
        }
        try {
            String toolchainPrefix;
            CoreModel coreModel = CCorePlugin.getDefault().getCoreModel();
            ICProjectDescription projectDesc = coreModel.getProjectDescription(project, true);
            if (projectDesc == null) {
                return new ApplyResult(false, "Project has no CDT configuration: " + project.getName());
            }
            boolean anyConfigured = false;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDesc.getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription configDesc = iCConfigurationDescriptionArray[n2];
                if (configDesc != null) {
                    this.configureEnvironmentVariables(configDesc, venv);
                    this.configureCrossGccToolchain(project, configDesc, venv);
                    anyConfigured = true;
                }
                ++n2;
            }
            if (!anyConfigured) {
                return new ApplyResult(false, "No build configurations found in project");
            }
            coreModel.setProjectDescription(project, projectDesc);
            StringBuilder sb = new StringBuilder();
            sb.append("CDT configuration applied to project: ").append(project.getName());
            sb.append("\n\nConfigured:");
            sb.append("\n- RUYI_VENV: ").append(venv.getPath());
            String toolchainPath = venv.getToolchainPath();
            if (toolchainPath != null && !toolchainPath.isEmpty()) {
                sb.append("\n- PATH prepended with: ").append(toolchainPath);
            }
            if ((toolchainPrefix = venv.getToolchainPrefix()) != null && !toolchainPrefix.isEmpty()) {
                sb.append("\n- Toolchain Prefix: ").append(toolchainPrefix);
            }
            LOGGER.logInfo("Venv configuration applied successfully: project=" + project.getName());
            return new ApplyResult(true, sb.toString());
        }
        catch (CoreException e) {
            LOGGER.logError("Failed to apply CDT configuration: project=" + projectPath, (Throwable)e);
            return new ApplyResult(false, "Failed to apply CDT configuration: " + e.getMessage());
        }
        catch (Exception e) {
            LOGGER.logError("Unexpected error applying venv configuration: project=" + projectPath, (Throwable)e);
            return new ApplyResult(false, "Unexpected error: " + e.getMessage());
        }
    }

    private void configureEnvironmentVariables(ICConfigurationDescription configDesc, Venv venv) {
        String toolchainPath;
        IEnvironmentVariableManager envManager = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IContributedEnvironment contribEnv = envManager.getContributedEnvironment();
        String venvPath = venv.getPath();
        if (venvPath != null && !venvPath.isEmpty()) {
            contribEnv.addVariable(ENV_RUYI_VENV, venvPath, 1, null, configDesc);
        }
        if ((toolchainPath = venv.getToolchainPath()) != null && !toolchainPath.isEmpty()) {
            contribEnv.addVariable("PATH", toolchainPath, 3, System.getProperty("path.separator"), configDesc);
        }
    }

    private void configureCrossGccToolchain(IProject project, ICConfigurationDescription configDesc, Venv venv) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            return;
        }
        IConfiguration config = buildInfo.getManagedProject().getConfiguration(configDesc.getId());
        if (config == null) {
            IConfiguration[] iConfigurationArray = buildInfo.getManagedProject().getConfigurations();
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration cfg = iConfigurationArray[n2];
                if (cfg != null && cfg.getName().equals(configDesc.getName())) {
                    config = cfg;
                    break;
                }
                ++n2;
            }
        }
        if (config == null) {
            return;
        }
        IToolChain toolChain = config.getToolChain();
        if (toolChain == null) {
            return;
        }
        String toolchainPrefix = venv.getToolchainPrefix();
        if (toolchainPrefix != null && !toolchainPrefix.isEmpty()) {
            Object prefixWithDash = toolchainPrefix.endsWith("-") ? toolchainPrefix : toolchainPrefix + "-";
            this.setToolChainOptionBySuperClassId(config, toolChain, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.prefix", (String)prefixWithDash);
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
    }

    private void setToolChainOptionBySuperClassId(IConfiguration config, IToolChain toolChain, String optionId, String value) {
        try {
            IOption option = toolChain.getOptionBySuperClassId(optionId);
            if (option != null) {
                config.setOption((IHoldsOptions)toolChain, option, value);
            }
        }
        catch (Exception exception) {}
    }

    public void applyToProjectAsync(final Venv venv, final Consumer<ApplyResult> callback) {
        Job applyJob = new Job("Applying venv configuration to CDT project"){

            protected IStatus run(IProgressMonitor monitor) {
                ApplyResult result = VenvConfigurationService.this.applyToProject(venv);
                if (callback != null) {
                    callback.accept(result);
                }
                return result.isSuccess() ? Status.OK_STATUS : new Status(2, VenvConfigurationService.PLUGIN_ID, result.getMessage());
            }
        };
        applyJob.schedule();
    }

    private IProject findProjectByPath(String projectPath) {
        if (projectPath == null || projectPath.isBlank()) {
            return null;
        }
        Path normalizedTarget = this.normalizePath(projectPath);
        if (normalizedTarget == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path projectLocation;
            IPath location;
            IProject project = iProjectArray[n2];
            if (project != null && (location = project.getLocation()) != null && (projectLocation = this.normalizePath(location.toOSString())) != null && projectLocation.equals(normalizedTarget)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private Path normalizePath(String pathString) {
        if (pathString == null || pathString.isBlank()) {
            return null;
        }
        try {
            return Paths.get(pathString, new String[0]).toRealPath(new LinkOption[0]);
        }
        catch (Exception exception) {
            try {
                return Paths.get(pathString, new String[0]).normalize().toAbsolutePath();
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static class ApplyResult {
        private final boolean success;
        private final String message;

        public ApplyResult() {
            this.success = true;
            this.message = "Configuration applied successfully";
        }

        public ApplyResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

