/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.venv;

import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.ruyisdk.ruyi.util.RuyiLogger;
import org.ruyisdk.venv.model.VenvConfigurationService;
import org.ruyisdk.venv.model.VenvDetectionService;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.ruyisdk.venv";
    private static Activator plugin;
    private static VenvDetectionService detectionService;
    private static VenvConfigurationService configService;
    private static final RuyiLogger LOGGER;

    static {
        LOGGER = new RuyiLogger(Platform.getLog((Bundle)FrameworkUtil.getBundle(Activator.class)), PLUGIN_ID);
    }

    public VenvDetectionService getDetectionService() {
        return detectionService;
    }

    public VenvConfigurationService getConfigService() {
        return configService;
    }

    public void start(BundleContext context) throws Exception {
        LOGGER.logInfo("Venv plugin starting");
        super.start(context);
        plugin = this;
        detectionService = new VenvDetectionService();
        configService = new VenvConfigurationService();
        LOGGER.logInfo("Venv plugin started");
    }

    public void stop(BundleContext context) throws Exception {
        LOGGER.logInfo("Venv plugin stopping");
        configService = null;
        detectionService = null;
        plugin = null;
        super.stop(context);
        LOGGER.logInfo("Venv plugin stopped");
    }

    public static RuyiLogger getLogger() {
        return LOGGER;
    }

    public static Activator getDefault() {
        return plugin;
    }
}

