/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.util;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RuyiLogger {
    private final ILog eclipseLog;
    private final String pluginId;

    public RuyiLogger(ILog eclipseLog) {
        this(eclipseLog, "org.ruyisdk.ruyi");
    }

    public RuyiLogger(ILog eclipseLog, String pluginId) {
        this.eclipseLog = eclipseLog;
        this.pluginId = pluginId == null ? "org.ruyisdk.ruyi" : pluginId;
    }

    public void logInfo(String message) {
        this.log(1, message, null);
    }

    public void logWarning(String message, Throwable exception) {
        this.log(2, message, exception);
    }

    public void logError(String message, Throwable exception) {
        this.log(4, message, exception);
    }

    public void log(int severity, String message, Throwable exception) {
        Status status = new Status(severity, this.pluginId, message, exception);
        this.eclipseLog.log((IStatus)status);
    }

    public void log(IStatus status) {
        this.eclipseLog.log(status);
    }
}

