/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.ui;

import java.io.IOException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.ruyisdk.core.ruyi.model.RepoConfig;
import org.ruyisdk.core.ruyi.model.RuyiVersion;
import org.ruyisdk.ruyi.Activator;
import org.ruyisdk.ruyi.preferences.RepoConfigPreference;
import org.ruyisdk.ruyi.preferences.RuyiInstallPathPreference;
import org.ruyisdk.ruyi.preferences.TelemetryPreference;
import org.ruyisdk.ruyi.services.RuyiInstallManager;
import org.ruyisdk.ruyi.services.RuyiProperties;
import org.ruyisdk.ruyi.ui.InstallProgressComposite;
import org.ruyisdk.ruyi.util.RuyiLogger;
import org.ruyisdk.ruyi.util.StatusUtil;

public class RuyiInstallWizard
extends Wizard {
    private static final RuyiLogger LOGGER = Activator.getLogger();
    private final Mode mode;
    private final RuyiVersion currentVersion;
    private final RuyiVersion newVersion;

    public static void openForInstall() {
        new RuyiInstallWizard(Mode.INSTALL, null, null).open();
    }

    public static void openForUpgrade(RuyiVersion current, RuyiVersion latest) {
        new RuyiInstallWizard(Mode.UPGRADE, current, latest).open();
    }

    private RuyiInstallWizard(Mode mode, RuyiVersion currentVersion, RuyiVersion newVersion) {
        this.mode = mode;
        this.currentVersion = currentVersion;
        this.newVersion = newVersion;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(mode == Mode.INSTALL ? "Ruyi Installation Wizard" : "Ruyi Upgrade Wizard");
    }

    public void addPages() {
        this.addPage((IWizardPage)new CheckResultPage(this.mode));
        this.addPage((IWizardPage)new PreparePage(this.mode));
        this.addPage((IWizardPage)new ConfigurationPage());
        this.addPage((IWizardPage)new InstallationPage(this.mode));
        this.addPage((IWizardPage)new CompletionPage(this.mode));
    }

    public boolean performFinish() {
        return ((InstallationPage)this.getPage("installationPage")).performFinish();
    }

    public void open() {
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)this);
        dialog.setMinimumPageSize(600, 400);
        dialog.open();
    }

    private class CheckResultPage
    extends WizardPage {
        private final Mode mode;
        private Button dontCheckAgainCheckbox;

        public CheckResultPage(Mode mode) {
            super("checkResultPage");
            this.mode = mode;
            this.setTitle(mode == Mode.INSTALL ? "Ruyi Installation Required" : "Ruyi Upgrade Available");
        }

        public void createControl(Composite parent) {
            FontData[] fontData;
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            Label infoLabel = new Label(container, 64);
            infoLabel.setLayoutData((Object)new GridData(4, 128, true, false));
            String showtext = this.mode == Mode.INSTALL ? "Ruyi package manager (ruyi command) not detected.  \n" : String.format("New Ruyi version %s available (current: %s).  \n", RuyiInstallWizard.this.newVersion, RuyiInstallWizard.this.currentVersion);
            infoLabel.setText(showtext);
            FontData[] fontDataArray = fontData = infoLabel.getFont().getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setName("Arial");
                fd.setHeight(12);
                fd.setStyle(1);
                ++n2;
            }
            final Font newFont = new Font((Device)infoLabel.getDisplay(), fontData);
            infoLabel.setFont(newFont);
            infoLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    newFont.dispose();
                }
            });
            Label hintLabel = new Label(container, 64);
            hintLabel.setLayoutData((Object)new GridData(4, 128, true, false));
            hintLabel.setText("Please note:\n\u2022 Click [Next] to start installation wizard.\n\u2022 Select [Cancel] to manually trigger from menu: RuyiSDK > Ruyi Installation.\n\u2022 If you already have ruyi, configure path in: Windows > Preferences > RuyiSDK > Ruyi Config > Ruyi Installation Directory.\n\n");
            Color tipColor = new Color((Device)hintLabel.getDisplay(), 0, 0, 255);
            hintLabel.setForeground(tipColor);
            hintLabel.addDisposeListener(e -> {
                if (!tipColor.isDisposed()) {
                    tipColor.dispose();
                }
            });
            this.dontCheckAgainCheckbox = new Button(container, 32);
            this.dontCheckAgainCheckbox.setText("Don't check and prompt again");
            this.dontCheckAgainCheckbox.setLayoutData((Object)new GridData(4, 128, true, false));
            this.dontCheckAgainCheckbox.addListener(13, e -> this.setAutomaticDetection());
            this.setControl((Control)container);
        }

        private void setAutomaticDetection() {
            try {
                RuyiProperties.setAutomaticDetection(!this.dontCheckAgainCheckbox.getSelection());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class CompletionPage
    extends WizardPage {
        private final Mode mode;

        public CompletionPage(Mode mode) {
            super("completionPage");
            this.mode = mode;
            this.setTitle("Operation Complete");
            this.setDescription(mode == Mode.INSTALL ? "Ruyi has been successfully installed" : "Ruyi has been upgraded successfully");
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            Label label = new Label(container, 64);
            label.setLayoutData((Object)new GridData(4, 4, true, true));
            String text = this.mode == Mode.INSTALL ? "Ruyi has been successfully installed!\n\nNext steps:\n\u2022 Restart your IDE to apply changes\n\u2022 Configure project SDK settings\n\u2022 Visit documentation for tutorials" : "Ruyi has been upgraded to the latest version.\n\nWhat's new:\n\u2022 Improved performance\n\u2022 New API features\n\u2022 Bug fixes";
            label.setText(text);
            this.setControl((Control)container);
        }

        public boolean isPageComplete() {
            return true;
        }

        public IWizardPage getPreviousPage() {
            return null;
        }
    }

    private class ConfigurationPage
    extends WizardPage {
        private RuyiInstallPathPreference installPref;
        private RepoConfigPreference repoPref;
        private TelemetryPreference telemetryPref;

        public ConfigurationPage() {
            super("configurationPage");
            this.setTitle("Configuration");
            this.setDescription("Configure installation options");
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            this.installPref = new RuyiInstallPathPreference(container);
            this.installPref.createSection();
            this.repoPref = new RepoConfigPreference(container);
            this.repoPref.createSection();
            this.telemetryPref = new TelemetryPreference(container);
            this.telemetryPref.createSection();
            this.setControl((Control)container);
        }

        public String getInstallPath() {
            return this.installPref.getTextPath();
        }

        public RepoConfig[] getSelectedRepos() {
            return this.repoPref.getSelectedRepos();
        }

        public RuyiProperties.TelemetryStatus getTelemetryStatus() {
            return this.telemetryPref.getTelemetryStatus();
        }

        public void saveConfig() {
            try {
                this.installPref.saveInstallPath();
                this.repoPref.saveRepoConfigs();
                this.telemetryPref.saveTelemetryConfigs();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface InstallationListener {
        public void progressChanged(int var1, String var2);

        public void logMessage(String var1);
    }

    private class InstallationPage
    extends WizardPage {
        private final Mode mode;
        private InstallProgressComposite progressComp;
        private RuyiInstallManager installManager;

        public InstallationPage(Mode mode) {
            super("installationPage");
            this.mode = mode;
            this.installManager = new RuyiInstallManager(LOGGER);
            this.setTitle(mode == Mode.INSTALL ? "Installing Ruyi" : "Upgrading Ruyi");
            this.setDescription(mode == Mode.INSTALL ? "Please wait while Ruyi is being installed" : "Upgrading to the latest version...");
        }

        public void createControl(Composite parent) {
            this.progressComp = new InstallProgressComposite(parent);
            this.setControl((Control)this.progressComp);
        }

        public IWizardPage getPreviousPage() {
            return null;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.startInstallation();
            }
        }

        private void startInstallation() {
            ConfigurationPage configPage = (ConfigurationPage)this.getWizard().getPage("configurationPage");
            configPage.saveConfig();
            this.installManager.setInstallPath(configPage.getInstallPath());
            this.installManager.setRepoUrls(configPage.getSelectedRepos());
            this.progressComp.appendLog("Starting " + (this.mode == Mode.INSTALL ? "installation" : "upgrade") + "...");
            Job.create((String)("Ruyi " + this.mode.name()), monitor -> {
                try {
                    this.installManager.install(monitor, new InstallationListener(){

                        @Override
                        public void progressChanged(int percent, String message) {
                            InstallationPage.this.updateProgress(percent, message);
                        }

                        @Override
                        public void logMessage(String message) {
                            InstallationPage.this.appendLog(message);
                        }
                    });
                    Display.getDefault().asyncExec(() -> {
                        this.progressComp.appendLog("Operation completed successfully!");
                        this.setPageComplete(true);
                    });
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Display.getDefault().asyncExec(() -> {
                        this.progressComp.appendLog("Failed: " + e.getMessage());
                        this.setPageComplete(false);
                        StatusUtil.logAndShow(String.valueOf((Object)this.mode) + " failed", e);
                    });
                    return StatusUtil.createErrorStatus(String.valueOf((Object)this.mode) + " failed", e);
                }
            }).schedule();
        }

        private void updateProgress(int percent, String message) {
            Display.getDefault().asyncExec(() -> this.progressComp.updateProgress(percent, message));
        }

        private void appendLog(String message) {
            Display.getDefault().asyncExec(() -> this.progressComp.appendLog(message));
        }

        public boolean performFinish() {
            return this.isPageComplete();
        }
    }

    public static enum Mode {
        INSTALL,
        UPGRADE;

    }

    private class PreparePage
    extends WizardPage {
        public PreparePage(Mode mode) {
            super("welcomePage");
            this.setTitle(mode == Mode.INSTALL ? "Welcome to Ruyi Installation" : "Welcome to Ruyi Upgrade");
            this.setDescription(mode == Mode.INSTALL ? "This wizard will guide you through the Ruyi installation process" : "This wizard will upgrade your Ruyi installation to the latest version");
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            Label label = new Label(container, 64);
            label.setLayoutData((Object)new GridData(4, 4, true, true));
            String text = RuyiInstallWizard.this.mode == Mode.INSTALL ? "The Ruyi SDK provides all necessary tools for Ruyi development. \n\nBefore proceeding, please ensure: \n\u2022 500MB+ free disk space \n\u2022 Active internet connection \n\u2022 Administrator privileges if needed" : "Your Ruyi installation will be upgraded to the latest version. \n\nPlease note: \n\u2022 The old version will be replaced \n\u2022 Existing configurations will be preserved \n\u2022 Active internet connection \n\u2022 Administrator privileges if needed";
            label.setText(text);
            this.setControl((Control)container);
        }
    }
}

