/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.ruyisdk.core.basedir.XdgDirs;
import org.ruyisdk.core.console.RuyiSdkConsole;
import org.ruyisdk.ruyi.util.RuyiFileUtils;

public class RuyiProperties {
    private static final Path CONFIG_DIR = XdgDirs.getConfigDir((String)"ruyisdkide");
    private static final Path FILE_PATH = CONFIG_DIR.resolve("ruyi.properties");
    private static final Properties props = RuyiProperties.loadConfig();

    static {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            if (!Files.exists(FILE_PATH, new LinkOption[0])) {
                RuyiProperties.initDefaultConfig();
            }
        }
        catch (IOException e) {
            RuyiProperties.handleConfigError("Failed to init config directory", e);
        }
    }

    private static Properties loadConfig() {
        Properties loadedProps = new Properties();
        if (Files.exists(FILE_PATH, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream is = Files.newInputStream(FILE_PATH, new OpenOption[0]);){
                    loadedProps.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                RuyiProperties.handleConfigError("Failed to load config file", e);
            }
        }
        return loadedProps;
    }

    private static void initDefaultConfig() throws IOException {
        Properties defaults = new Properties();
        defaults.setProperty("automatic.detection", "on");
        defaults.setProperty("ruyi.telemetry.status", "on");
        defaults.setProperty("ruyi.install.path", RuyiFileUtils.getDefaultInstallPath().toString());
        defaults.setProperty("ruyi.mirror.custom", "");
        defaults.setProperty("ruyi.mirror.iscas.checked", "1");
        defaults.setProperty("ruyi.mirror.github.checked", "1");
        defaults.setProperty("ruyi.mirror.custom.checked", "0");
        RuyiProperties.saveConfig(defaults);
        props.putAll((Map<?, ?>)defaults);
    }

    private static synchronized void saveConfig(Properties propsToSave) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (OutputStream os = Files.newOutputStream(FILE_PATH, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            propsToSave.store(os, "Ruyi Configuration");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static synchronized void saveConfig() throws IOException {
        RuyiProperties.saveConfig(props);
    }

    public static boolean isAutomaticDetectionEnabled() {
        return "on".equalsIgnoreCase(props.getProperty("automatic.detection"));
    }

    public static void setAutomaticDetection(boolean enabled) throws IOException {
        props.setProperty("automatic.detection", enabled ? "on" : "off");
        RuyiProperties.saveConfig();
    }

    public static String getInstallPath() {
        return props.getProperty("ruyi.install.path");
    }

    public static void setInstallPath(String path) throws IOException {
        props.setProperty("ruyi.install.path", path != null ? path : "");
        RuyiProperties.saveConfig();
    }

    public static String getCustomMirror() {
        return props.getProperty("ruyi.mirror.custom");
    }

    public static void setCustomMirror(String url) throws IOException {
        props.setProperty("ruyi.mirror.custom", url != null ? url : "");
        RuyiProperties.saveConfig();
    }

    public static boolean isIscasMirrorChecked() {
        return "1".equals(props.getProperty("ruyi.mirror.iscas.checked"));
    }

    public static void setIscasMirrorChecked(boolean checked) throws IOException {
        props.setProperty("ruyi.mirror.iscas.checked", checked ? "1" : "0");
        RuyiProperties.saveConfig();
    }

    public static boolean isGithubMirrorChecked() {
        return "1".equals(props.getProperty("ruyi.mirror.github.checked"));
    }

    public static void setGithubMirrorChecked(boolean checked) throws IOException {
        props.setProperty("ruyi.mirror.github.checked", checked ? "1" : "0");
        RuyiProperties.saveConfig();
    }

    public static boolean isCustomMirrorChecked() {
        return "1".equals(props.getProperty("ruyi.mirror.custom.checked"));
    }

    public static void setCustomMirrorChecked(boolean checked) throws IOException {
        props.setProperty("ruyi.mirror.custom.checked", checked ? "1" : "0");
        RuyiProperties.saveConfig();
    }

    public static TelemetryStatus getTelemetryStatus() {
        try {
            return TelemetryStatus.valueOf(props.getProperty("ruyi.telemetry.status").toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return TelemetryStatus.ON;
        }
    }

    public static void setTelemetryStatus(TelemetryStatus status) throws IOException {
        props.setProperty("ruyi.telemetry.status", status.name().toLowerCase(Locale.ROOT));
        RuyiProperties.saveConfig();
    }

    public static void setTelemetryStatus(boolean status) throws IOException {
        props.setProperty("ruyi.telemetry.status", status ? "on" : "off");
        RuyiProperties.saveConfig();
    }

    private static void handleConfigError(String message, Exception e) {
        RuyiSdkConsole.getInstance().logError(message + ": " + e.getMessage());
    }

    public static enum TelemetryStatus {
        ON,
        LOCAL,
        OFF;

    }
}

