/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.ruyisdk.core.ruyi.model.RuyiVersion;
import org.ruyisdk.ruyi.services.RuyiProperties;

public class RuyiCommand {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RuyiVersion getInstalledVersion(String ruyiPath) {
        try {
            Process process = new ProcessBuilder(ruyiPath + "/ruyi", "-V").start();
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String firstLine = reader.readLine();
                if (firstLine == null) {
                    return null;
                }
                String prefix = "Ruyi ";
                if (!firstLine.startsWith(prefix)) return null;
                String versionStr = firstLine.substring(prefix.length()).trim();
                if (!versionStr.matches("^\\d+\\.\\d+\\.\\d+$")) return null;
                return RuyiVersion.parse((String)versionStr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static void setRepoRemote(String ruyiPath, String repourl) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(ruyiPath + "/ruyi", "config", "set", "repo.remote", repourl);
        pb.redirectErrorStream(true);
        try {
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String output = new String(process.getInputStream().readAllBytes());
                throw new Exception("ruyi config set repo.remote execution failure. \n" + output);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new Exception("Failed to set repo.remote. ", e);
        }
    }

    public static String getRepoRemote(String ruyiPath) {
        try {
            Process process = new ProcessBuilder(ruyiPath + "/ruyi", "config", "get", "repo.remote").start();
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String firstLine = reader.readLine();
                return firstLine;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void updateRuyi(String ruyiPath) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(ruyiPath + "/ruyi", "update");
        pb.redirectErrorStream(true);
        try {
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String output = new String(process.getInputStream().readAllBytes());
                throw new Exception("ruyi update execution failure. \n" + output);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new Exception("Failed to update index. ", e);
        }
    }

    public static void setTelemetry(String ruyiPath, RuyiProperties.TelemetryStatus status) throws Exception {
        String parameter = "consent";
        switch (status) {
            case ON: {
                parameter = "consent";
                break;
            }
            case LOCAL: {
                parameter = "local";
                break;
            }
            case OFF: {
                parameter = "optout";
                break;
            }
            default: {
                parameter = "consent";
            }
        }
        ProcessBuilder pb = new ProcessBuilder(ruyiPath + "/ruyi", "telemetry", parameter);
        pb.redirectErrorStream(true);
        try {
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String output = new String(process.getInputStream().readAllBytes());
                throw new Exception("ruyi telemetry execution failure. \n" + output);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new Exception("Failed to run ruyi telemetry. ", e);
        }
    }

    public static String getTelemetryStatus(String ruyiPath) {
        try {
            Process process = new ProcessBuilder(ruyiPath + "/ruyi", "telemetry", "status").start();
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String firstLine = reader.readLine();
                return firstLine;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void telemetryUpload(String ruyiPath) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(ruyiPath + "/ruyi", "telemetry", "upload");
        pb.redirectErrorStream(true);
        try {
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String output = new String(process.getInputStream().readAllBytes());
                throw new Exception("ruyi telemetry upload execution failure. \n" + output);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new Exception("Failed to upload telemetry data. ", e);
        }
    }
}

