/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;
import org.ruyisdk.core.ruyi.model.RuyiReleaseInfo;
import org.ruyisdk.core.ruyi.model.RuyiVersion;
import org.ruyisdk.core.ruyi.model.SystemInfo;
import org.ruyisdk.ruyi.services.RuyiApiException;

public class RuyiApi {
    private static final String BASE_URL = "https://api.ruyisdk.cn";
    private static final int TIMEOUT = 10000;

    public static RuyiReleaseInfo getLatestRelease(String osArch) throws RuyiApiException {
        try {
            JSONObject response = RuyiApi.sendGetRequest("/releases/latest-pm");
            JSONObject stable = response.getJSONObject("channels").getJSONObject("stable");
            String platformKey = SystemInfo.getPlatformKey();
            System.out.println("platformKey==" + platformKey);
            JSONObject downloads = stable.getJSONObject("download_urls");
            if (!downloads.has(platformKey)) {
                throw new RuyiApiException("Unsupported architecture: " + osArch);
            }
            String[] urls = (String[])downloads.getJSONArray(platformKey).toList().stream().map(Object::toString).toArray(String[]::new);
            String version = stable.getString("version");
            String filename = urls[0].split(version + "/")[1];
            return new RuyiReleaseInfo(RuyiVersion.parse((String)version), stable.getString("channel"), filename, urls[0], urls[1]);
        }
        catch (Exception e) {
            throw new RuyiApiException("Failed to get release info: " + e.getMessage(), e);
        }
    }

    private static JSONObject sendGetRequest(String path) throws IOException {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            String line;
            conn = (HttpURLConnection)new URL(BASE_URL + path).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            if (conn.getResponseCode() != 200) {
                throw new IOException("HTTP " + conn.getResponseCode());
            }
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            JSONObject jSONObject = new JSONObject(response.toString());
            return jSONObject;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

