/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.preferences;

import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.ruyisdk.ruyi.services.RuyiProperties;

public class TelemetryPreference {
    private final Composite parent;
    private Combo telemetryCombo;

    public TelemetryPreference(Composite parent) {
        this.parent = parent;
    }

    public void createSection() {
        Group group = new Group(this.parent, 0);
        group.setText("Telemetry Settings");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite comboContainer = new Composite((Composite)group, 0);
        comboContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        comboContainer.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(comboContainer, 0);
        label.setText("Telemetry data collection:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.telemetryCombo = new Combo(comboContainer, 12);
        this.telemetryCombo.setItems(new String[]{"Enabled: Send anonymous usage data", "Local only: Analyze data locally only", "Disabled: No data collection"});
        this.telemetryCombo.select(this.initTelemetryStatus());
        this.telemetryCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Link link = new Link((Composite)group, 64);
        String description = "RuyiSDK \u9065\u6d4b\u6570\u636e\u79c9\u6301\u6700\u5c0f\u5316\u6536\u96c6\u4fe1\u606f\u7684\u539f\u5219\uff0c\u5c3d\u53ef\u80fd\u907f\u514d\u6536\u96c6\u7528\u6237\u4e2a\u4eba\u8eab\u4efd\u4fe1\u606f\uff0c\u4e14\u91c7\u7528\u533f\u540d\u5316\u65b9\u5f0f\u6536\u96c6\u4fe1\u606f\u7528\u4e8e\u4ea7\u54c1\u7684\u8fd0\u8425\u548c\u670d\u52a1\u7684\u63d0\u5347\u3002\u53ef\u524d\u5f80 Windows > Preferences > Ruyi \u4e2d\u8fdb\u884c\u8bbe\u7f6e\u4fee\u6539\u3002\u8be6\u89c1";
        String linkText = "<a href=\"https://ruyisdk.org/docs/legal/privacyPolicy\">RuyiSDK\u9690\u79c1\u653f\u7b56</a>";
        link.setText(description + " " + linkText);
        GridData linkLayoutData = new GridData(4, 0x1000000, true, false);
        linkLayoutData.widthHint = 400;
        link.setLayoutData((Object)linkLayoutData);
        group.layout(true);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Program.launch((String)event.text);
            }
        });
    }

    public RuyiProperties.TelemetryStatus getTelemetryStatus() {
        switch (this.telemetryCombo.getSelectionIndex()) {
            case 0: {
                return RuyiProperties.TelemetryStatus.ON;
            }
            case 1: {
                return RuyiProperties.TelemetryStatus.LOCAL;
            }
            case 2: {
                return RuyiProperties.TelemetryStatus.OFF;
            }
        }
        return RuyiProperties.TelemetryStatus.ON;
    }

    public void setTelemetryStatus(RuyiProperties.TelemetryStatus status) {
        switch (status) {
            case ON: {
                this.telemetryCombo.select(0);
                break;
            }
            case LOCAL: {
                this.telemetryCombo.select(1);
                break;
            }
            case OFF: {
                this.telemetryCombo.select(2);
                break;
            }
            default: {
                this.telemetryCombo.select(0);
            }
        }
    }

    public void defaultedTelemetryState() {
        this.telemetryCombo.select(0);
    }

    public void saveTelemetryConfigs() throws IOException {
        RuyiProperties.setTelemetryStatus(this.getTelemetryStatus());
    }

    public int initTelemetryStatus() {
        switch (RuyiProperties.getTelemetryStatus()) {
            case ON: {
                return 0;
            }
            case LOCAL: {
                return 1;
            }
            case OFF: {
                return 2;
            }
        }
        return 0;
    }
}

