/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.ruyisdk.core.ruyi.model.CheckResult;
import org.ruyisdk.core.ruyi.model.RuyiVersion;
import org.ruyisdk.ruyi.Activator;
import org.ruyisdk.ruyi.services.RuyiManager;
import org.ruyisdk.ruyi.util.RuyiLogger;

public class CheckRuyiJob {
    private static final RuyiLogger LOGGER = Activator.getLogger();

    public CheckResult runCheck(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Checking Ruyi environment", 3);
            monitor.subTask("Checking installation");
            if (!this.isInstalled()) {
                CheckResult checkResult = CheckResult.needInstall((String)"Ruyi is not installed");
                return checkResult;
            }
            monitor.worked(1);
            monitor.subTask("Detecting current version");
            RuyiVersion current = this.getInstalledVersion();
            monitor.worked(1);
            monitor.subTask("Checking latest version");
            RuyiVersion latest = this.getLatestRelease();
            if (latest != null && current.compareTo(latest) < 0) {
                CheckResult checkResult = CheckResult.needUpgrade((RuyiVersion)current, (RuyiVersion)latest, (String)String.format("New version available: %s (current: %s)", latest.toString(), current.toString()));
                return checkResult;
            }
            CheckResult checkResult = CheckResult.ok();
            return checkResult;
        }
        catch (OperationCanceledException e) {
            LOGGER.logInfo("Version check cancelled");
            throw e;
        }
        catch (Exception e) {
            LOGGER.logError("Version check failed", e);
            throw new RuntimeException("Check failed: " + e.getMessage(), e);
        }
        finally {
            monitor.done();
        }
    }

    private boolean isInstalled() {
        System.out.println("Ruyi is installed ? " + RuyiManager.isRuyiInstalled());
        return RuyiManager.isRuyiInstalled();
    }

    private RuyiVersion getInstalledVersion() {
        System.out.println("Ruyi is installed ? " + RuyiManager.isRuyiInstalled());
        return RuyiManager.getInstalledVersion();
    }

    private RuyiVersion getLatestRelease() {
        System.out.println("Ruyi has new version: " + String.valueOf(RuyiManager.getLatestVersion()));
        return RuyiManager.getLatestVersion();
    }
}

