/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.ruyi.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.ruyisdk.core.ruyi.model.CheckResult;
import org.ruyisdk.ruyi.jobs.CheckRuyiJob;
import org.ruyisdk.ruyi.services.RuyiProperties;
import org.ruyisdk.ruyi.ui.RuyiInstallWizard;
import org.ruyisdk.ruyi.util.RuyiLogger;

public class RuyiCore {
    private volatile boolean isChecking;
    private final RuyiLogger logger;

    public RuyiCore(RuyiLogger logger) {
        this.logger = logger;
    }

    public void startBackgroundCheck() {
        boolean autocheck = this.autoCheckAtStartup();
        this.logger.logInfo("RuyiAutoCheck set :" + autocheck);
        if (this.isChecking || !autocheck) {
            return;
        }
        this.isChecking = true;
        Job.create((String)"Ruyi Environment Check", monitor -> {
            try {
                CheckResult result = new CheckRuyiJob().runCheck(monitor);
                this.handleCheckResult(result);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                this.isChecking = false;
            }
        }).schedule(2000L);
    }

    public void startBackgroundJobs() {
    }

    public void shutdown() {
        this.logger.logInfo("RuyiCore services stopped successfully");
    }

    public void runManualCheck() {
        Job.create((String)"Manual Ruyi Check", monitor -> {
            CheckResult result = new CheckRuyiJob().runCheck(monitor);
            this.handleCheckResult(result);
            return Status.OK_STATUS;
        }).schedule();
    }

    private void handleCheckResult(CheckResult result) {
        Display.getDefault().asyncExec(() -> {
            switch (result.getAction()) {
                case INSTALL: {
                    RuyiInstallWizard.openForInstall();
                    break;
                }
                case UPGRADE: {
                    RuyiInstallWizard.openForUpgrade(result.getCurrentVersion(), result.getLatestVersion());
                    break;
                }
                case NOTHING: {
                    this.logger.logInfo(result.getMessage());
                    break;
                }
                default: {
                    this.logger.logError("Unknown check result action", null);
                }
            }
        });
    }

    private boolean autoCheckAtStartup() {
        return RuyiProperties.isAutomaticDetectionEnabled();
    }

    private boolean confirmAction(String title, String message) {
        return MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)title, (String)(message + "\n\nWould you like to proceed?"));
    }
}

