/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.news.views;

import java.util.regex.Pattern;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import org.ruyisdk.news.Activator;
import org.ruyisdk.news.model.NewsItem;
import org.ruyisdk.news.viewmodel.NewsDetailsViewModel;
import org.ruyisdk.news.viewmodel.NewsListViewModel;

public class NewsView
extends ViewPart {
    public static final String ID = "org.ruyisdk.news.views.NewsView";
    private Composite topComposite;
    private Composite middleComposite;
    private Composite bottomComposite;
    private Text searchTextBox;
    private Button unreadCheckBox;
    private TableViewer tableViewer;
    private Text detailTextBox;
    private Button updateButton;
    private Label updateInfoLabel;
    private Button hideDetailsButton;
    private DataBindingContext dbc;
    private NewsDetailsViewModel newsDetailsViewModel;
    private NewsListViewModel newsListViewModel;

    public void createPartControl(Composite parent) {
        this.dbc = new DataBindingContext();
        this.newsDetailsViewModel = new NewsDetailsViewModel(Activator.getDefault().getService());
        this.newsListViewModel = new NewsListViewModel(Activator.getDefault().getService());
        this.createLayouts(parent);
        this.addControls();
        this.registerEvents();
        this.toggleDetailControls(false);
        this.newsListViewModel.onUpdateNewsListAsync();
    }

    private void createLayouts(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.topComposite = new Composite(parent, 0);
        this.topComposite.setLayoutData((Object)new GridData(768));
        this.topComposite.setLayout((Layout)new GridLayout(3, false));
        this.middleComposite = new Composite(parent, 0);
        this.middleComposite.setLayoutData((Object)new GridData(1808));
        this.middleComposite.setLayout((Layout)new GridLayout(1, false));
        this.bottomComposite = new Composite(parent, 0);
        this.bottomComposite.setLayoutData((Object)new GridData(768));
        this.bottomComposite.setLayout((Layout)new GridLayout(3, false));
    }

    private void addControls() {
        new Label(this.topComposite, 0).setText("Search:");
        this.searchTextBox = new Text(this.topComposite, 2052);
        this.searchTextBox.setLayoutData((Object)new GridData(768));
        this.searchTextBox.setMessage("Title or ID");
        this.unreadCheckBox = new Button(this.topComposite, 32);
        this.unreadCheckBox.setLayoutData((Object)new GridData(128));
        this.unreadCheckBox.setText("Unread Only");
        Composite tableComposite = new Composite(this.middleComposite, 0);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        tableComposite.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(tableComposite, 2048);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0x1000000);
        TableColumn tableColumn = column.getColumn();
        tableColumn.setText("Unread");
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(5, 60));
        column = new TableViewerColumn(this.tableViewer, 0);
        tableColumn = column.getColumn();
        tableColumn.setText("Title");
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(100, 20));
        column = new TableViewerColumn(this.tableViewer, 0);
        tableColumn = column.getColumn();
        tableColumn.setText("ID");
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(50, 20));
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        ObservableMapLabelProvider labelProvider = new ObservableMapLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])BeanProperties.values(NewsItem.class, (String[])new String[]{"unread", "title", "id"}))){

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((NewsItem)element).getUnread() ? "*" : "";
                }
                return super.getColumnText(element, columnIndex);
            }
        };
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.setInput(this.newsListViewModel.getNewsList());
        this.detailTextBox = new Text(this.middleComposite, 2626);
        GridData gridData2 = new GridData(1808);
        gridData2.heightHint = 100;
        this.detailTextBox.setLayoutData((Object)gridData2);
        this.updateButton = new Button(this.bottomComposite, 8);
        this.updateButton.setLayoutData((Object)new GridData(32));
        this.updateButton.setText("Update");
        this.updateInfoLabel = new Label(this.bottomComposite, 0);
        this.updateInfoLabel.setLayoutData((Object)new GridData(32));
        this.updateInfoLabel.setText("<updateInfo>");
        this.hideDetailsButton = new Button(this.bottomComposite, 8);
        this.hideDetailsButton.setLayoutData((Object)new GridData(640));
        this.hideDetailsButton.setText("Hide Details");
    }

    private void registerEvents() {
        new ComputedValue<NewsListViewerFilter>(){

            protected NewsListViewerFilter calculate() {
                NewsListViewerFilter newsFilter = new NewsListViewerFilter();
                newsFilter.setPattern((String)WidgetProperties.text((int)24).observe((Widget)NewsView.this.searchTextBox).getValue());
                newsFilter.setOnlyUnread((Boolean)WidgetProperties.buttonSelection().observe((Widget)NewsView.this.unreadCheckBox).getValue());
                return newsFilter;
            }
        }.addValueChangeListener(e -> {
            this.tableViewer.resetFilters();
            this.tableViewer.addFilter((ViewerFilter)e.diff.getNewValue());
        });
        this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (NewsView.this.tableViewer.getTable().getItem(new Point(e.x, e.y)) == null) {
                    NewsView.this.tableViewer.getTable().deselectAll();
                    NewsView.this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsView.this.updateButton.setEnabled(false);
                NewsView.this.newsListViewModel.onUpdateNewsListAsync();
            }
        });
        this.hideDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsView.this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        });
        IViewerObservableValue selectionObservable = ViewerProperties.singleSelection(NewsItem.class).observe((Viewer)this.tableViewer);
        selectionObservable.addValueChangeListener(e -> {
            NewsItem selected = (NewsItem)e.diff.getNewValue();
            if (selected != null) {
                this.newsDetailsViewModel.onAcquireNewsDetails(selected);
                this.toggleDetailControls(true);
            } else {
                this.toggleDetailControls(false);
            }
        });
        this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.detailTextBox), BeanProperties.value(NewsItem.class, (String)"details", String.class).observeDetail((IObservableValue)selectionObservable));
        ISWTObservableValue updateInfoObservable = WidgetProperties.text().observe((Widget)this.updateInfoLabel);
        updateInfoObservable.addValueChangeListener(e -> this.updateInfoLabel.requestLayout());
        this.dbc.bindValue((IObservableValue)updateInfoObservable, BeanProperties.value(NewsListViewModel.class, (String)"infoText", String.class).observe((Object)this.newsListViewModel));
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.updateButton), (IObservableValue)new ComputedValue<Boolean>(){

            protected Boolean calculate() {
                return (Boolean)BeanProperties.value(NewsListViewModel.class, (String)"fetching", Boolean.class).observe((Object)NewsView.this.newsListViewModel).getValue() == false;
            }
        });
    }

    private void toggleDetailControls(Boolean isShow) {
        this.hideDetailsButton.setEnabled(isShow.booleanValue());
        ((GridData)this.detailTextBox.getLayoutData()).exclude = isShow == false;
        this.detailTextBox.requestLayout();
    }

    public void setFocus() {
    }

    static class NewsListViewerFilter
    extends ViewerFilter {
        private String pattern = "";
        private Boolean onlyUnread = false;

        NewsListViewerFilter() {
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setOnlyUnread(Boolean onlyUnread) {
            this.onlyUnread = onlyUnread;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean matchesUnread;
            NewsItem newsItem = (NewsItem)element;
            Pattern compiledPattern = Pattern.compile(Pattern.quote(this.pattern), 2);
            boolean matchesPattern = compiledPattern.matcher(newsItem.getTitle()).find() || compiledPattern.matcher(newsItem.getId()).find();
            boolean onlyUnreadValue = Boolean.TRUE.equals(this.onlyUnread);
            boolean bl = matchesUnread = !onlyUnreadValue || newsItem.getUnread();
            return matchesPattern && matchesUnread;
        }
    }
}

