/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.news.viewmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.ruyisdk.news.model.NewsFetchService;
import org.ruyisdk.news.model.NewsItem;

public class NewsListViewModel {
    private boolean isFetching = false;
    private String infoText = "Not Updated, yet";
    private NewsFetchService service;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final IObservableList<NewsItem> observableNewsList = new WritableList(new ArrayList(), NewsItem.class);

    public NewsListViewModel(NewsFetchService service) {
        this.service = service;
    }

    public IObservableList<NewsItem> getNewsList() {
        return this.observableNewsList;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String getInfoText() {
        return this.infoText;
    }

    public void setInfoText(String infoText) {
        this.infoText = infoText;
        this.pcs.firePropertyChange("infoText", this.infoText, this.infoText);
    }

    public void setFetching(boolean isFetching) {
        this.isFetching = isFetching;
        this.pcs.firePropertyChange("fetching", this.isFetching, this.isFetching);
    }

    public boolean isFetching() {
        return this.isFetching;
    }

    public void onUpdateNewsListAsync() {
        if (this.isFetching()) {
            return;
        }
        this.setFetching(true);
        this.setInfoText("Updating...");
        this.service.fetchNewsListAsync(result -> {
            ArrayList<NewsItem> sorted = new ArrayList<NewsItem>((Collection<NewsItem>)result);
            sorted.sort(Comparator.comparingInt(NewsItem::getOrd).reversed());
            this.observableNewsList.getRealm().asyncExec(() -> {
                this.observableNewsList.clear();
                this.observableNewsList.addAll((Collection)sorted);
            });
            this.setInfoText(String.format("Last Updated on %s", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))));
            this.setFetching(false);
        });
    }

    private class UpdatingState {
        private static final String notUpdated = "Not Updated, yet";
        private static final String updating = "Updating...";
        private static final String updatedTemplate = "Last Updated on %s";

        private UpdatingState() {
        }
    }
}

