/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.packages;

import java.util.Map;
import javax.json.JsonValue;
import org.eclipse.jface.viewers.LabelProvider;

public class PackageLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)element;
            return String.valueOf(entry.getKey()) + ": " + this.getJsonValueText((JsonValue)entry.getValue());
        }
        if (element instanceof JsonValue) {
            return this.getJsonValueText((JsonValue)element);
        }
        return super.getText(element);
    }

    private String getJsonValueText(JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                return "{...}";
            }
            case ARRAY: {
                return "[...]";
            }
            case STRING: {
                return value.toString().replace("\"", "");
            }
            case NUMBER: {
                return value.toString();
            }
            case TRUE: 
            case FALSE: {
                return value.toString();
            }
            case NULL: {
                return "null";
            }
        }
        return value.toString();
    }
}

