/*
 * Decompiled with CFR 0.152.
 */
package org.ruyisdk.devices.views;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.ruyisdk.devices.model.Device;

public class DeviceDialog
extends TitleAreaDialog {
    private Device device;
    private String titleText;
    private Text nameText;
    private Text chipText;
    private Text vendorText;
    private Text versionText;

    public DeviceDialog(Shell parentShell, Device device) {
        super(parentShell);
        this.device = device;
        this.titleText = device == null ? "Add New Device" : "Edit Device";
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Device Manage");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.titleText);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(container, 0).setText("Name:");
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(container, 0).setText("Chip:");
        this.chipText = new Text(container, 2048);
        this.chipText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(container, 0).setText("Vendor:");
        this.vendorText = new Text(container, 2048);
        this.vendorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(container, 0).setText("Version:");
        this.versionText = new Text(container, 2048);
        this.versionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.device != null) {
            this.nameText.setText(this.device.getName());
            this.chipText.setText(this.device.getChip());
            this.vendorText.setText(this.device.getVendor());
            this.versionText.setText(this.device.getVersion());
        }
        return area;
    }

    protected void okPressed() {
        this.device = new Device(this.nameText.getText(), this.chipText.getText(), this.vendorText.getText(), this.versionText.getText(), false);
        super.okPressed();
    }

    public Device getDevice() {
        return this.device;
    }
}

